"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostsCount = getHostsCount;
var _server = require("@kbn/observability-plugin/server");
var _constants = require("../../../../../common/constants");
var _utils = require("../utils");
var _query = require("../helpers/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHostsCount({
  infraMetricsClient,
  apmDataAccessServices,
  query,
  from,
  to,
  schema
}) {
  var _response$aggregation, _response$aggregation2;
  (0, _utils.assertQueryStructure)(query);
  const apmDocumentSources = await (apmDataAccessServices === null || apmDataAccessServices === void 0 ? void 0 : apmDataAccessServices.getDocumentSources({
    start: from,
    end: to
  }));
  const documentsFilter = await (0, _query.getDocumentsFilter)({
    apmDataAccessServices,
    apmDocumentSources,
    from,
    to,
    schema
  });
  const response = await infraMetricsClient.search({
    allow_no_indices: true,
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: [query, ...(0, _server.rangeQuery)(from, to), {
          bool: {
            should: [...documentsFilter]
          }
        }]
      }
    },
    aggs: {
      totalCount: {
        cardinality: {
          field: _constants.HOST_NAME_FIELD
        }
      }
    }
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.totalCount.value) !== null && _response$aggregation !== void 0 ? _response$aggregation : 0;
}