"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logIndexSavedObjectReferenceRT = exports.logIndexPatternSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = exports.kibanaAdvancedSettingSavedObjectReferenceRT = exports.TimestampFromString = exports.SourceConfigurationSavedObjectTimestampColumnRT = exports.SourceConfigurationSavedObjectRT = exports.SourceConfigurationSavedObjectMessageColumnRT = exports.SourceConfigurationSavedObjectFieldColumnRT = exports.SourceConfigurationSavedObjectColumnRT = exports.SourceConfigurationSavedObjectAttributesRT = exports.SavedSourceConfigurationSavedObjectRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimestampFromString = exports.TimestampFromString = new rt.Type('TimestampFromString', input => typeof input === 'number', (input, context) => (0, _pipeable.pipe)(rt.string.validate(input, context), (0, _Either.chain)(stringInput => {
  const momentValue = (0, _moment.default)(stringInput);
  return momentValue.isValid() ? rt.success(momentValue.valueOf()) : rt.failure(stringInput, context);
})), output => new Date(output).toISOString());
const SourceConfigurationSavedObjectFieldColumnRT = exports.SourceConfigurationSavedObjectFieldColumnRT = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
const SourceConfigurationSavedObjectMessageColumnRT = exports.SourceConfigurationSavedObjectMessageColumnRT = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationSavedObjectTimestampColumnRT = exports.SourceConfigurationSavedObjectTimestampColumnRT = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationSavedObjectColumnRT = exports.SourceConfigurationSavedObjectColumnRT = rt.union([SourceConfigurationSavedObjectTimestampColumnRT, SourceConfigurationSavedObjectMessageColumnRT, SourceConfigurationSavedObjectFieldColumnRT]);
const logIndexPatternSavedObjectReferenceRT = exports.logIndexPatternSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_pattern'),
  indexPatternId: rt.string
});
const logIndexNameSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
const kibanaAdvancedSettingSavedObjectReferenceRT = exports.kibanaAdvancedSettingSavedObjectReferenceRT = rt.type({
  type: rt.literal('kibana_advanced_setting')
});
const logIndexSavedObjectReferenceRT = exports.logIndexSavedObjectReferenceRT = rt.union([logIndexPatternSavedObjectReferenceRT, logIndexNameSavedObjectReferenceRT, kibanaAdvancedSettingSavedObjectReferenceRT]);
const SourceConfigurationSavedObjectAttributesRT = exports.SourceConfigurationSavedObjectAttributesRT = rt.type({
  name: rt.string,
  description: rt.string,
  metricAlias: rt.string,
  logIndices: logIndexSavedObjectReferenceRT,
  inventoryDefaultView: rt.string,
  metricsExplorerDefaultView: rt.string,
  logColumns: rt.array(SourceConfigurationSavedObjectColumnRT),
  anomalyThreshold: rt.number
});
const SavedSourceConfigurationSavedObjectRT = exports.SavedSourceConfigurationSavedObjectRT = rt.partial(SourceConfigurationSavedObjectAttributesRT.props);
const SourceConfigurationSavedObjectRT = exports.SourceConfigurationSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: SavedSourceConfigurationSavedObjectRT
}), rt.partial({
  version: rt.string,
  updated_at: TimestampFromString
})]);