"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLazyRef = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLazyRef = initializer => {
  const ref = (0, _react.useRef)(null);
  if (ref.current === null) {
    ref.current = initializer();
  }
  return ref;
};
exports.useLazyRef = useLazyRef;