"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedObjectUserPermissions = void 0;
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedObjectUserPermissions = () => {
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const canSave = capabilities.savedObjectsManagement.edit === true;
  const canDelete = capabilities.savedObjectsManagement.delete === true;
  return {
    canSave,
    canDelete
  };
};
exports.useSavedObjectUserPermissions = useSavedObjectUserPermissions;