"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertFlyout = void 0;
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _types = require("../../../../common/alerting/logs/log_threshold/types");
var _triggers_actions_context = require("../../../containers/triggers_actions_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/alert_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertFlyout = props => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    visible,
    setVisible
  } = props;
  const {
    triggersActionsUI
  } = (0, _react.useContext)(_triggers_actions_context.TriggerActionsContext);
  const onCloseFlyout = (0, _react.useCallback)(() => setVisible(false), [setVisible]);
  const AddAlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUI) return null;
    const {
      ruleTypeRegistry,
      actionTypeRegistry
    } = triggersActionsUI;
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
      plugins: {
        ...services,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      consumer: "logs",
      onCancel: onCloseFlyout,
      onSubmit: onCloseFlyout,
      ruleTypeId: _types.LOG_DOCUMENT_COUNT_RULE_TYPE_ID,
      initialMetadata: {
        isInternal: true
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    });
  }, [triggersActionsUI, services, onCloseFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && AddAlertFlyout);
};
exports.AlertFlyout = AlertFlyout;