"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogThresholdCountChart = LogThresholdCountChart;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _create_lens_definition = require("./create_lens_definition");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/alert_details_app_section/components/threhsold_chart/log_threshold_count_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LogThresholdCountChart({
  kql,
  index,
  threshold,
  timeRange,
  alertRange,
  height,
  interval = 'auto',
  filter = ''
}) {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const lensDef = (0, _create_lens_definition.createLensDefinitionForCountChart)(index, euiTheme, kql, threshold, alertRange, interval, filter);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "logThresholdCountChart",
    style: {
      height
    },
    timeRange: timeRange,
    attributes: lensDef,
    viewMode: 'view',
    noPadding: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}