"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInventoryMetricRuleType = createInventoryMetricRuleType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _metrics = require("../../../common/alerting/metrics");
var _validation = require("./components/validation");
var _rule_data_formatters = require("./rule_data_formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/inventory/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const inventoryDefaultActionMessage = _i18n.i18n.translate('xpack.infra.metrics.alerting.inventory.threshold.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Affected: '{{context.group}}'
- Metric: '{{context.metric}}'
- Observed value: '{{context.value}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const inventoryDefaultRecoveryMessage = _i18n.i18n.translate('xpack.infra.metrics.alerting.inventory.threshold.defaultRecoveryMessage', {
  defaultMessage: `Recovered '{{context.reason}}'

    '{{rule.name}}' has recovered.

- Affected: '{{context.group}}'
- Metric: '{{context.metric}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const LazyRuleParamsExpression = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression'))));
function createInventoryMetricRuleType({
  assetDetailsLocator,
  inventoryLocator
}) {
  const format = (0, _rule_data_formatters.getRuleFormat)({
    assetDetailsLocator,
    inventoryLocator
  });
  return {
    id: _metrics.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID,
    description: _i18n.i18n.translate('xpack.infra.metrics.inventory.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when the inventory exceeds a defined threshold.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.infrastructureThreshold}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback: null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LazyRuleParamsExpression, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }))),
    validate: _validation.validateMetricThreshold,
    defaultActionMessage: inventoryDefaultActionMessage,
    defaultRecoveryMessage: inventoryDefaultRecoveryMessage,
    requiresAppContext: false,
    format,
    priority: 20
  };
}