"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricExpression = exports.ClosablePopoverTitle = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _visualizations = require("../../../common/visualizations");
var _metrics_source = require("../../../containers/metrics_source");
var _get_custom_metric_label = require("../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../common/http_api/snapshot_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/inventory/components/metrics_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const V2ToLegacyMapping = {
  txV2: 'tx',
  rxV2: 'rx',
  cpuV2: 'cpu'
};
const AGGREGATION_LABELS = {
  ['avg']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.avg', {
    defaultMessage: 'Average'
  }),
  ['max']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.max', {
    defaultMessage: 'Max'
  }),
  ['min']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.min', {
    defaultMessage: 'Min'
  }),
  ['rate']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.rate', {
    defaultMessage: 'Rate'
  })
};
const aggregationOptions = _snapshot_api.SNAPSHOT_CUSTOM_AGGREGATIONS.map(k => ({
  text: AGGREGATION_LABELS[k],
  value: k
}));
const firstFieldOption = {
  text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.selectFieldLabel', {
    defaultMessage: 'Select a metric'
  }),
  value: ''
};
const MetricExpression = ({
  metric,
  metrics,
  customMetric,
  errors,
  onChange,
  onChangeCustom,
  popupPosition,
  nodeType
}) => {
  var _errors$metric;
  const [popoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const [customMetricTabOpen, setCustomMetricTabOpen] = (0, _react.useState)((metric === null || metric === void 0 ? void 0 : metric.value) === 'custom');
  const [selectedOption, setSelectedOption] = (0, _react.useState)(metric === null || metric === void 0 ? void 0 : metric.value);
  const [fieldDisplayedCustomLabel, setFieldDisplayedCustomLabel] = (0, _react.useState)(customMetric === null || customMetric === void 0 ? void 0 : customMetric.label);
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const fieldOptions = (0, _react.useMemo)(() => {
    var _metricsView$fields;
    return ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).filter(f => f.aggregatable && f.type === 'number' && !((customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) === f.name)).map(f => ({
      label: f.name
    }));
  }, [metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields, customMetric === null || customMetric === void 0 ? void 0 : customMetric.field]);
  const expressionDisplayValue = (0, _react.useMemo)(() => {
    return customMetricTabOpen ? (customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) && (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : (metric === null || metric === void 0 ? void 0 : metric.text) || firstFieldOption.text;
  }, [customMetricTabOpen, metric, customMetric]);
  const onChangeTab = (0, _react.useCallback)(id => {
    if (id === 'metric-popover-custom') {
      setCustomMetricTabOpen(true);
      onChange('custom');
    } else {
      setCustomMetricTabOpen(false);
      onChange(selectedOption);
    }
  }, [setCustomMetricTabOpen, onChange, selectedOption]);
  const onAggregationChange = (0, _react.useCallback)(e => {
    const value = e.target.value;
    const aggValue = _snapshot_api.SnapshotCustomAggregationRT.is(value) ? value : 'avg';
    const newCustomMetric = {
      ...customMetric,
      aggregation: aggValue
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const onFieldChange = (0, _react.useCallback)(selectedOptions => {
    const newCustomMetric = {
      ...customMetric,
      field: selectedOptions[0].label
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const debouncedOnChangeCustom = (0, _lodash.debounce)(onChangeCustom, 500);
  const onLabelChange = (0, _react.useCallback)(e => {
    setFieldDisplayedCustomLabel(e.target.value);
    const newCustomMetric = {
      ...customMetric,
      label: e.target.value
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) debouncedOnChangeCustom(newCustomMetric);
  }, [customMetric, debouncedOnChangeCustom]);
  const metricsToRemove = metrics.map(currentMetric => {
    return V2ToLegacyMapping[currentMetric.value];
  }).filter(m => !!m);
  const availableFieldsOptions = (0, _react.useMemo)(() => metrics.filter(availableMetric => (metric === null || metric === void 0 ? void 0 : metric.value) === availableMetric.value || !metricsToRemove.includes(availableMetric.value)).map(m => {
    return {
      label: m.text,
      value: m.value
    };
  }), [metric === null || metric === void 0 ? void 0 : metric.value, metrics, metricsToRemove]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "metricPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.whenLabel', {
        defaultMessage: 'When'
      }),
      value: expressionDisplayValue
      // @ts-expect-error upgrade typescript v5.1.6
      ,
      isActive: Boolean(popoverOpen || errors.metric && errors.metric.length > 0),
      onClick: togglePopover,
      color: (_errors$metric = errors.metric) !== null && _errors$metric !== void 0 && _errors$metric.length ? 'danger' : 'success',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 9
      }
    }),
    isOpen: popoverOpen,
    closePopover: closePopover,
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    zIndex: 8000,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 620
    },
    onBlur: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.expression.metric.popoverTitle",
    defaultMessage: "Metric",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: "Metric type",
    options: [{
      id: 'metric-popover-default',
      label: 'Default metric'
    }, {
      id: 'metric-popover-custom',
      label: 'Custom metric'
    }],
    idSelected: customMetricTabOpen ? 'metric-popover-custom' : 'metric-popover-default',
    onChange: onChangeTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }), customMetricTabOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metricExpression.select.ariaLabel', {
      defaultMessage: 'Select a field'
    }),
    "data-test-subj": "infraMetricExpressionSelect",
    onChange: onAggregationChange,
    value: (customMetric === null || customMetric === void 0 ? void 0 : customMetric.aggregation) || 'avg',
    options: aggregationOptions,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.infra.waffle.customMetrics.of', {
    defaultMessage: 'of'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metricExpression.selectafieldComboBox.ariaLabel', {
      defaultMessage: 'Select a field'
    }),
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.fieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: customMetric !== null && customMetric !== void 0 && customMetric.field ? [{
      label: customMetric.field
    }] : [],
    options: fieldOptions,
    onChange: onFieldChange,
    isClearable: false
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.metric.length > 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.labelLabel', {
      defaultMessage: 'Metric name (optional)'
    }),
    display: "rowCompressed",
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.helpText', {
      defaultMessage: 'Choose a name to help identify your custom metric. Defaults to "<function> of <field name>".',
      ignoreTag: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraMetricExpressionFieldText",
    name: "label",
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.labelPlaceholder', {
      defaultMessage: 'Choose a name to appear in the "Metric" dropdown'
    }),
    value: fieldDisplayedCustomLabel,
    fullWidth: true,
    onChange: onLabelChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 13
    }
  }, nodeType === 'host' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "alertFlyoutHostMetricsDocumentationLink",
    href: _visualizations.HOST_METRICS_DOC_HREF,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.whatAreTheseMetricsLink', {
    defaultMessage: 'What are these metrics?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "actOf__metricContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metricExpression.comboBox.ariaLabel', {
      defaultMessage: 'Select a metric'
    }),
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "availableFieldsOptionsComboBox"
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.metric.length > 0,
    placeholder: firstFieldOption.text,
    options: availableFieldsOptions,
    noSuggestions: !availableFieldsOptions.length,
    selectedOptions: metric ? availableFieldsOptions.filter(a => a.value === metric.value) : [],
    renderOption: o => o.label,
    onChange: selectedOptions => {
      if (selectedOptions.length > 0) {
        onChange(selectedOptions[0].value);
        setSelectedOption(selectedOptions[0].value);
      } else {
        onChange();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 17
    }
  }))))));
};
exports.MetricExpression = MetricExpression;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraClosablePopoverTitleButton",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 11
    }
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;