"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageRole = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Enum for all possible {@link Message} roles.
 */
let MessageRole = exports.MessageRole = /*#__PURE__*/function (MessageRole) {
  MessageRole["User"] = "user";
  MessageRole["Assistant"] = "assistant";
  MessageRole["Tool"] = "tool";
  return MessageRole;
}({});
/**
 * Base type for all subtypes of {@link Message}.
 */
/**
 * Represents a message from the user.
 */
/**
 * Represents a message from the LLM.
 */
/**
 * Represents a tool invocation result, following a request from the LLM to execute a tool.
 */
/**
 * Mixin composed of all the possible types of messages in a chatComplete discussion.
 *
 * Message can be of three types:
 * - {@link UserMessage}
 * - {@link AssistantMessage}
 * - {@link ToolMessage}
 */
/**
 * Utility type to get the Assistant message type of a {@link ToolOptions} type.
 */
/**
 * Shape for tool responses
 */
/**
 * Utility type to get the Tool message type of a {@link ToolOptions} type.
 */
/**
 * Utility type to get the mixin Message type of a {@link ToolOptions} type.
 */