"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelsDeploymentModal = TrainedModelsDeploymentModal;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _utils = require("../../../../components/mappings_editor/lib/utils");
var _lib = require("../../../../components/mappings_editor/lib");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/trained_models_deployment_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ML_APP_LOCATOR = 'ML_APP_LOCATOR';
const TRAINED_MODELS_MANAGE = 'trained_models';
function TrainedModelsDeploymentModal({
  errorsInTrainedModelDeployment = {},
  forceSaveMappings,
  saveMappings,
  saveMappingsLoading,
  setErrorsInTrainedModelDeployment
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    fields,
    inferenceToModelIdMap
  } = (0, _mappings_state_context.useMappingsState)();
  const {
    url
  } = (0, _app_context.useAppContext)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const closeModal = () => setIsModalVisible(false);
  const [mlManagementPageUrl, setMlManagementPageUrl] = (0, _react.useState)('');
  const [allowForceSaveMappings, setAllowForceSaveMappings] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const mlLocator = url === null || url === void 0 ? void 0 : url.locators.get(ML_APP_LOCATOR);
    const generateUrl = async () => {
      if (mlLocator) {
        const mlURL = await mlLocator.getUrl({
          page: TRAINED_MODELS_MANAGE
        });
        setMlManagementPageUrl(mlURL);
      }
    };
    generateUrl();
  }, [url]);
  const inferenceIdsInPendingList = (0, _react.useMemo)(() => {
    return Object.values((0, _lib.deNormalize)(fields)).filter(_utils.isSemanticTextField).map(field => field.inference_id);
  }, [fields]);
  const [pendingDeployments, setPendingDeployments] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const models = inferenceIdsInPendingList.map(inferenceId => inferenceToModelIdMap !== null && inferenceToModelIdMap !== void 0 && inferenceToModelIdMap[inferenceId] ? {
      inferenceId,
      ...(inferenceToModelIdMap === null || inferenceToModelIdMap === void 0 ? void 0 : inferenceToModelIdMap[inferenceId])
    } : undefined); // filter out third-party models
    const allPendingDeployments = models.map(model => {
      return model !== null && model !== void 0 && model.trainedModelId && !(model !== null && model !== void 0 && model.isDeployed) ? model === null || model === void 0 ? void 0 : model.inferenceId : '';
    }).filter(id => !!id);
    const uniqueDeployments = allPendingDeployments.filter((deployment, index) => allPendingDeployments.indexOf(deployment) === index);
    setPendingDeployments(uniqueDeployments);
  }, [inferenceIdsInPendingList, inferenceToModelIdMap]);
  const erroredDeployments = pendingDeployments.filter(deployment => errorsInTrainedModelDeployment[deployment]);
  (0, _react.useEffect)(() => {
    if (erroredDeployments.length > 0 || pendingDeployments.length > 0) {
      setIsModalVisible(true);
    } else {
      setIsModalVisible(false);
    }
  }, [erroredDeployments.length, pendingDeployments.length]);
  return isModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    style: {
      width: 600
    },
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    "data-test-subj": "trainedModelsDeploymentModal",
    initialFocus: "[data-test-subj=tryAgainModalButton]",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    title: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, erroredDeployments.length > 0 ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.deploymentErrorTitle', {
    defaultMessage: 'Models could not be deployed'
  }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.titleLabel', {
    defaultMessage: 'Models still deploying'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "trainedModelsDeploymentModalText",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, erroredDeployments.length > 0 ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.deploymentErrorText', {
    defaultMessage: 'There was an error when trying to deploy the following models.'
  }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.textAboutDeploymentsNotCompleted', {
    defaultMessage: 'Some fields are referencing models that have not yet completed deployment. Deployment may take a few minutes to complete.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: mlManagementPageUrl,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.textTrainedModelManagementLink', {
    defaultMessage: 'Go to Trained Model Management'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      listStyleType: 'none'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, (erroredDeployments.length > 0 ? erroredDeployments : pendingDeployments).map(deployment => /*#__PURE__*/_react.default.createElement("li", {
    key: deployment,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  }, deployment))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsConfirmLabel', {
      defaultMessage: 'Saving mappings without a deployed model may cause errors'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsDescription', {
    defaultMessage: 'Saving a semantic text field referencing a model that is not running will break ingesting documents and searching over documents using or referencing that field.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "allowForceSaveMappingsCheckbox",
    id: "allowForceSaveMappings",
    checked: allowForceSaveMappings,
    onChange: () => setAllowForceSaveMappings(!allowForceSaveMappings),
    label: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.allowForceSaveMappingsLabel', {
      defaultMessage: 'Allow semantic text mapping updates without a deployed model'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel and close modal'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: saveMappings,
    "data-test-subj": "tryAgainModalButton",
    isLoading: saveMappingsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.tryAgainButtonLabel', {
    defaultMessage: 'Try again'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: forceSaveMappings,
    disabled: !allowForceSaveMappings,
    isLoading: saveMappingsLoading,
    "data-test-subj": "forceSaveMappingsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.trainedModelsDeploymentModal.forceSaveMappingsLabel', {
    defaultMessage: 'Force save mappings'
  })))))) : null;
}