"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _searchApiPanels = require("@kbn/search-api-panels");
var _app_context = require("../../../../../app_context");
var _services = require("../../../../../services");
var _languages = require("./languages");
var _status_details = require("./status_details");
var _data_stream_details = require("./data_stream_details");
var _storage_details = require("./storage_details");
var _aliases_details = require("./aliases_details");
var _size_doc_count_details = require("./size_doc_count_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_overview/details_page_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetailsPageOverview = ({
  indexDetails
}) => {
  const {
    name,
    status,
    health,
    documents,
    documents_deleted: documentsDeleted,
    primary,
    replica,
    aliases,
    data_stream: dataStream,
    size,
    primary_size: primarySize
  } = indexDetails;
  const {
    core,
    plugins,
    services: {
      extensionsService
    }
  } = (0, _app_context.useAppContext)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_languages.curlDefinition);
  const [elasticsearchUrl, setElasticsearchUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    var _plugins$cloud;
    (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.fetchElasticsearchConfig().then(config => {
      setElasticsearchUrl(config.elasticsearchUrl || 'https://your_deployment_url');
    });
  }, [plugins.cloud]);
  const codeSnippetArguments = {
    url: elasticsearchUrl,
    apiKey: 'your_api_key',
    indexName: name
  };
  const isLarge = (0, _eui.useIsWithinBreakpoints)(['xl']);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isLarge ? 3 : 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_storage_details.StorageDetails, {
    size: size,
    primarySize: primarySize,
    primary: primary,
    replica: replica,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_status_details.StatusDetails, {
    documents: documents,
    documentsDeleted: documentsDeleted,
    status: status,
    health: health,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_size_doc_count_details.SizeDocCountDetails, {
    size: size,
    documents: documents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_aliases_details.AliasesDetails, {
    aliases: aliases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), dataStream && /*#__PURE__*/_react.default.createElement(_data_stream_details.DataStreamDetails, {
    dataStreamName: dataStream,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 24
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), extensionsService.indexOverviewContent ? extensionsService.indexOverviewContent.renderContent({
    index: indexDetails,
    getUrlForApp: core.getUrlForApp
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.addMoreDataTitle', {
    defaultMessage: 'Add data to this index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.overviewTab.addMoreDataDescription",
    defaultMessage: "Use the bulk API to add data to your index. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _services.documentationService.getBulkApi(),
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.overviewTab.addDocsLink",
        defaultMessage: "Learn more.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 27
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    languages: _languages.languageDefinitions,
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'ingestDataIndex', codeSnippetArguments),
    selectedLanguage: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: core.http.basePath.prepend(`/plugins/indexManagement/assets`),
    sharePlugin: plugins.share,
    application: core.application,
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('ingestDataIndex', codeSnippetArguments),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }))));
};
exports.DetailsPageOverview = DetailsPageOverview;