"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PointType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../lib");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/field_types/point_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultToggleValue = (param, field) => {
  return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
};
const PointType = ({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreMalformedParameter, {
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.point.ignoreMalformedFieldDescription', {
      defaultMessage: 'By default, documents that contain malformed points are not indexed. If enabled, these documents are indexed, but fields with malformed points are filtered out. Be careful: if too many documents are indexed this way, queries on the field become meaningless.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreZValueParameter, {
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.point.ignoreZValueFieldDescription', {
      defaultMessage: 'Three dimension points will be accepted, but only x and y values will be indexed; the third dimension is ignored.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.NullValueParameter, {
    defaultToggleValue: getDefaultToggleValue('null_value', field.source),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.point.nullValueFieldDescription', {
      defaultMessage: 'Replace explicit null values with a point value so that it can be indexed and searched.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "null_value",
    component: _shared_imports.TextAreaField,
    config: (0, _lib.getFieldConfig)('null_value_point'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })));
};
exports.PointType = PointType;