"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relationsSerializer = exports.relationsDeserializer = exports.RelationsParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../shared_imports");
var _documentation = require("../../../../../services/documentation");
var _edit_field = require("../fields/edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/relations_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This is the Elasticsearch interface to declare relations

// Internally we will use this type for "relations" as it is more UI friendly
// to loop over the relations and its children

/**
 * Export custom serializer to be used when we need to serialize the form data to be sent to ES
 * @param field The field to be serialized
 */
const relationsSerializer = field => {
  if (field.relations === undefined) {
    return field;
  }
  const relations = field.relations;
  const relationsSerialized = relations.reduce((acc, item) => ({
    ...acc,
    [item.parent]: item.children.length === 1 ? item.children[0] : item.children
  }), {});
  return {
    ...field,
    relations: relationsSerialized
  };
};

/**
 * Export custom deserializer to be used when we need to deserialize the data coming from ES
 * @param field The field to be serialized
 */
exports.relationsSerializer = relationsSerializer;
const relationsDeserializer = field => {
  if (field.relations === undefined) {
    return field;
  }
  const relations = field.relations;
  const relationsDeserialized = Object.entries(relations).map(([parent, children]) => ({
    parent,
    children: typeof children === 'string' ? [children] : children
  }));
  return {
    ...field,
    relations: relationsDeserialized
  };
};
exports.relationsDeserializer = relationsDeserializer;
const childConfig = {
  defaultValue: []
};
const RelationsParameter = () => {
  const renderWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.join.multiLevelsParentJoinWarningTitle",
      defaultMessage: "Avoid using multiple levels to replicate a relational model. Each relation level increases computation time and memory consumption at query time. For best performance, {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getJoinMultiLevelsPerformanceLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.join.multiLevelsPerformanceDocumentationLink', {
          defaultMessage: 'denormalize your data.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.relationshipsTitle', {
      defaultMessage: 'Relationships'
    }),
    withToggle: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseArray, {
    path: "relations",
    initialNumberOfItems: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    const columns = [
    // Parent column
    {
      name: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.parentColumnTitle', {
        defaultMessage: 'Parent'
      }),
      render: item => {
        // By adding ".parent" to the path, we are saying that we want an **object**
        // to be created for each array item.
        // This object will have a "parent" property with the field value.
        return /*#__PURE__*/_react.default.createElement("div", {
          style: {
            width: '100%'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
          path: `${item.path}.parent`,
          component: _shared_imports.TextField,
          componentProps: {
            euiFieldProps: {
              'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.parentFieldAriaLabel', {
                defaultMessage: 'Parent field'
              })
            }
          }
          // For a newly created relation, we don't want to read
          // its default value provided to the form because... it is new! :)
          ,
          readDefaultValueOnForm: !item.isNew,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 21
          }
        }));
      }
    },
    // Children column (ComboBox)
    {
      name: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.childrenColumnTitle', {
        defaultMessage: 'Children'
      }),
      render: item => {
        return /*#__PURE__*/_react.default.createElement("div", {
          style: {
            width: '100%'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 172,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
          path: `${item.path}.children`,
          config: childConfig,
          component: _shared_imports.ComboBoxField,
          componentProps: {
            euiFieldProps: {
              'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.childrenFieldAriaLabel', {
                defaultMessage: 'Children field'
              })
            }
          },
          readDefaultValueOnForm: !item.isNew,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 21
          }
        }));
      }
    },
    // Actions column
    {
      width: '48px',
      actions: [{
        render: ({
          id
        }) => {
          const label = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.removeRelationshipTooltipLabel', {
            defaultMessage: 'Remove relationship'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            delay: "long",
            disableScreenReaderOutput: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 206,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "data-test-subj": "removeRelationshipButton",
            "aria-label": label,
            iconType: "minusInCircle",
            color: "danger",
            onClick: () => removeItem(id),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 207,
              columnNumber: 25
            }
          }));
        }
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: items,
      itemId: "id",
      columns: columns,
      noItemsMessage: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.relationshipTable.emptyTableMessage', {
        defaultMessage: 'No relationship defined'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: addItem,
      iconType: "plusInCircleFilled",
      "data-test-subj": "addRelationButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.joinType.addRelationshipButtonLabel', {
      defaultMessage: 'Add relationship'
    })));
  }));
};
exports.RelationsParameter = RelationsParameter;