"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrientationParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _edit_field = require("../fields/edit_field");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/orientation_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OrientationParameter = ({
  defaultToggleValue
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShapeType.orientationFieldTitle', {
    defaultMessage: 'Set orientation'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShapeType.orientationFieldDescription', {
    defaultMessage: 'Interpret the vertex order for polygons and multipolygons as either clockwise or counterclockwise (default).'
  }),
  defaultToggleValue: defaultToggleValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "orientation",
  config: (0, _lib.getFieldConfig)('orientation'),
  component: _shared_imports.Field,
  componentProps: {
    euiFieldProps: {
      options: _constants.PARAMETERS_OPTIONS.orientation,
      style: {
        minWidth: 300
      }
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}));
exports.OrientationParameter = OrientationParameter;