"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShrinkField = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _edit_policy_context = require("../../../edit_policy_context");
var _form = require("../../../form");
var _i18n_texts = require("../../../i18n_texts");
var _ = require("../..");
var _constants = require("../../../constants");
var _unit_field = require("./unit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/shrink_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShrinkField = ({
  phase
}) => {
  var _policy$phases$phase, _policy$phases$phase$;
  const globalFields = (0, _form.useGlobalFields)();
  const {
    setValue: setIsUsingShardSize
  } = globalFields[`${phase}IsUsingShardSize`];
  const {
    policy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const isUsingShardSizePath = `_meta.${phase}.shrink.isUsingShardSize`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [isUsingShardSizePath]
  });
  const isUsingShardSize = (0, _lodash.get)(formData, isUsingShardSizePath);
  const path = `phases.${phase}.actions.shrink.${isUsingShardSize ? 'max_primary_shard_size' : 'number_of_shards'}`;
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 14
      }
    }, _i18n_texts.i18nTexts.editPolicy.shrinkActionLabel),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.shrinkIndexExplanationText",
      defaultMessage: "Shrink the index to a new index with fewer primary shards.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmShrink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    })),
    titleSize: "xs",
    switchProps: {
      'data-test-subj': `${phase}-shrinkSwitch`,
      label: _i18n_texts.i18nTexts.editPolicy.shrinkToggleLabel,
      initialValue: Boolean((_policy$phases$phase = policy.phases[phase]) === null || _policy$phases$phase === void 0 ? void 0 : (_policy$phases$phase$ = _policy$phases$phase.actions) === null || _policy$phases$phase$ === void 0 ? void 0 : _policy$phases$phase$.shrink)
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, isUsingShardSize === undefined ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: `${phase}ShrinkMethod`,
    options: [{
      id: `${phase}-configureShardCount`,
      label: _i18n_texts.i18nTexts.editPolicy.shrinkCountLabel,
      'data-test-subj': `${phase}-configureShardCount`
    }, {
      id: `${phase}-configureShardSize`,
      label: _i18n_texts.i18nTexts.editPolicy.shrinkSizeLabel,
      'data-test-subj': `${phase}-configureShardSize`
    }],
    idSelected: isUsingShardSize ? `${phase}-configureShardSize` : `${phase}-configureShardCount`,
    onChange: id => setIsUsingShardSize(id === `${phase}-configureShardSize`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: path,
    key: path,
    component: _shared_imports.NumericField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': `${phase}-primaryShard${isUsingShardSize ? 'Size' : 'Count'}`,
        min: 1,
        append: isUsingShardSize ? /*#__PURE__*/_react.default.createElement(_unit_field.UnitField, {
          path: `_meta.${phase}.shrink.maxPrimaryShardSizeUnits`,
          options: _constants.byteSizeUnits,
          euiFieldProps: {
            'data-test-subj': `${phase}-shrinkMaxPrimaryShardSizeUnits`,
            'aria-label': _i18n_texts.i18nTexts.editPolicy.maxPrimaryShardSizeUnitsLabel
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 19
          }
        }) : null
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `phases.${phase}.actions.shrink.allow_write_after_shrink`,
    key: `phases.${phase}.actions.shrink.allow_write_after_shrink`,
    component: _shared_imports.ToggleField,
    euiFieldProps: {
      'data-test-subj': `${phase}-allowWriteAfterShrink`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })));
};
exports.ShrinkField = ShrinkField;