"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlTemplatesReducer = exports.templatesSelector = exports.syncTemplatesSaga = exports.saveTemplate = exports.removeTemplate = exports.loadTemplates = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
var _dist = require("typescript-fsa-reducers/dist");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _effects = require("redux-saga/effects");
var _url = require("url");
var _global = require("./global");
var _datasource = require("./datasource");
var _outlink_encoders = require("../helpers/outlink_encoders");
var _url_template = require("../helpers/url_template");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/graph/urlTemplates');
const loadTemplates = exports.loadTemplates = actionCreator('LOAD_TEMPLATES');
const saveTemplate = exports.saveTemplate = actionCreator('SAVE_TEMPLATE');
const removeTemplate = exports.removeTemplate = actionCreator('REMOVE_TEMPLATE');
const initialTemplates = [];
function generateDefaultTemplate(datasource, addBasePath) {
  const appPath = (0, _std.modifyUrl)('/', parsed => {
    parsed.query._a = _rison.default.encode({
      columns: ['_source'],
      index: datasource.id,
      interval: 'auto',
      query: {
        language: 'kuery',
        query: _url_template.urlTemplatePlaceholder
      },
      sort: ['_score', 'desc']
    });
  });
  const parsedAppPath = (0, _url.parse)(`/app/discover#${appPath}`, true, true);
  const formattedAppPath = (0, _url.format)({
    protocol: parsedAppPath.protocol,
    host: parsedAppPath.host,
    pathname: parsedAppPath.pathname,
    query: parsedAppPath.query,
    hash: parsedAppPath.hash
  });

  // replace the URI encoded version of the tag with the unescaped version
  // so it can be found with String.replace, regexp, etc.
  const discoverUrl = addBasePath(formattedAppPath).replace(encodeURIComponent(_url_template.urlTemplatePlaceholder), _url_template.urlTemplatePlaceholder);
  return {
    url: discoverUrl,
    description: _i18n.i18n.translate('xpack.graph.settings.drillDowns.defaultUrlTemplateTitle', {
      defaultMessage: 'Raw documents'
    }),
    encoder: _outlink_encoders.outlinkEncoders[0],
    isDefault: true,
    icon: null
  };
}
const urlTemplatesReducer = addBasePath => (0, _dist.reducerWithInitialState)(initialTemplates).case(_global.reset, () => initialTemplates).cases([_datasource.requestDatasource, _datasource.setDatasource], (templates, datasource) => {
  if (datasource.type === 'none') {
    return initialTemplates;
  }
  const customTemplates = templates.filter(template => !template.isDefault);
  return [...customTemplates, generateDefaultTemplate(datasource, addBasePath)];
}).case(loadTemplates, (_currentTemplates, newTemplates) => {
  return newTemplates.map(template => {
    var _template$url;
    return template.isDefault && (_template$url = template.url) !== null && _template$url !== void 0 && _template$url.startsWith('/app/discover') // as in saved objects of sample data sets
    ? {
      ...template,
      url: addBasePath(template.url).replace(encodeURIComponent(_url_template.urlTemplatePlaceholder), _url_template.urlTemplatePlaceholder)
    } : template;
  });
}).case(saveTemplate, (templates, {
  index: indexToUpdate,
  template: updatedTemplate
}) => {
  // set default flag to false as soon as template is overwritten.
  const newTemplate = {
    ...updatedTemplate,
    isDefault: false
  };
  return indexToUpdate === -1 ? [...templates, newTemplate] : templates.map((template, index) => index === indexToUpdate ? newTemplate : template);
}).case(removeTemplate, (templates, templateToDelete) => templates.filter(template => template !== templateToDelete)).build();
exports.urlTemplatesReducer = urlTemplatesReducer;
const templatesSelector = state => state.urlTemplates;

/**
 * Saga making sure the templates are always synced up to the scope.
 *
 * Won't be necessary once the side bar is moved to redux
 */
exports.templatesSelector = templatesSelector;
const syncTemplatesSaga = ({
  notifyReact
}) => {
  function* syncTemplates() {
    notifyReact();
  }
  return function* () {
    yield (0, _effects.takeEvery)((0, _helpers.matchesOne)(loadTemplates, saveTemplate, removeTemplate, _datasource.requestDatasource, _datasource.setDatasource), syncTemplates);
  };
};
exports.syncTemplatesSaga = syncTemplatesSaga;