"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
exports.SearchBarComponent = SearchBarComponent;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _react2 = require("@emotion/react");
var _source_modal = require("../services/source_modal");
var _state_management = require("../state_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function queryToString(query, indexPattern) {
  if (query.language === 'kuery' && typeof query.query === 'string') {
    const dsl = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query), indexPattern);
    // JSON representation of query will be handled by existing logic.
    // TODO clean this up and handle it in the data fetch layer once
    // it moved to typescript.
    return JSON.stringify(dsl);
  }
  if (typeof query.query === 'string') {
    return query.query;
  }
  return JSON.stringify(query.query);
}
function SearchBarComponent(props) {
  const {
    isLoading,
    urlQuery,
    currentIndexPattern,
    currentDatasource,
    indexPatternProvider,
    selectedFields,
    submit,
    onIndexPatternSelected,
    confirmWipeWorkspace,
    onIndexPatternChange
  } = props;
  const [query, setQuery] = (0, _react.useState)({
    language: 'kuery',
    query: urlQuery || ''
  });
  (0, _react.useEffect)(() => setQuery(prev => ({
    language: prev.language,
    query: urlQuery || ''
  })), [urlQuery]);
  (0, _react.useEffect)(() => {
    async function fetchPattern() {
      if (currentDatasource) {
        onIndexPatternChange(await indexPatternProvider.get(currentDatasource.id));
      } else {
        onIndexPatternChange(undefined);
      }
    }
    fetchPattern();
  }, [currentDatasource, indexPatternProvider, onIndexPatternChange]);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    services,
    overlays
  } = (0, _public.useKibana)();
  const {
    uiSettings,
    appName,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    },
    contentManagement
  } = services;
  if (!overlays) return null;
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: e => {
      e.preventDefault();
      if (!isLoading && currentIndexPattern) {
        submit(queryToString(query, currentIndexPattern));
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.graph.bar.pickSourceTooltip', {
      defaultMessage: 'Select a data source to begin graphing relationships.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "graphDatasourceButton",
    size: "s",
    css: (0, _react2.css)`
                max-width: 320px;
                ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's'])} {
                  width: 100%;
                  max-width: none;
                }
              `,
    onClick: () => {
      confirmWipeWorkspace(() => (0, _source_modal.openSourceModal)({
        overlays,
        contentManagement,
        uiSettings
      }, onIndexPatternSelected), _i18n.i18n.translate('xpack.graph.clearWorkspace.confirmText', {
        defaultMessage: 'If you change data sources, your current fields and vertices will be reset.'
      }), {
        confirmButtonText: _i18n.i18n.translate('xpack.graph.clearWorkspace.confirmButtonLabel', {
          defaultMessage: 'Change data source'
        }),
        title: _i18n.i18n.translate('xpack.graph.clearWorkspace.modalTitle', {
          defaultMessage: 'Unsaved changes'
        })
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, currentIndexPattern ? currentIndexPattern.getName() :
  // This branch will be shown if the user exits the
  // initial picker modal
  _i18n.i18n.translate('xpack.graph.bar.pickSourceLabel', {
    defaultMessage: 'Select a data source'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    timeRangeForSuggestionsOverride: false // to don't filter suggestions by the global time range
    ,
    disableAutoFocus: true,
    bubbleSubmitEvent: true,
    indexPatterns: currentIndexPattern ? [currentIndexPattern] : [],
    placeholder: _i18n.i18n.translate('xpack.graph.bar.searchFieldPlaceholder', {
      defaultMessage: 'Search your data and add to graph'
    }),
    query: query,
    onChange: setQuery,
    appName: appName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    condition: !currentIndexPattern || !selectedFields.length,
    tooltipContent: !currentIndexPattern ? _i18n.i18n.translate('xpack.graph.bar.exploreLabelNoIndexPattern', {
      defaultMessage: 'Select a data source'
    }) : _i18n.i18n.translate('xpack.graph.bar.exploreLabelNoFields', {
      defaultMessage: 'Select at least one field'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    size: "s",
    disabled: isLoading || !currentIndexPattern || !selectedFields.length,
    "data-test-subj": "graph-explore-button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.graph.bar.exploreLabel', {
    defaultMessage: 'Graph'
  }))))));
}
const SearchBar = exports.SearchBar = (0, _reactRedux.connect)(state => {
  const datasource = (0, _state_management.datasourceSelector)(state);
  return {
    currentDatasource: datasource.current.type === 'indexpattern' ? datasource.current : undefined,
    selectedFields: (0, _state_management.selectedFieldsSelector)(state)
  };
}, dispatch => ({
  onIndexPatternSelected: indexPattern => {
    dispatch((0, _state_management.requestDatasource)({
      type: 'indexpattern',
      id: indexPattern.id,
      title: indexPattern.attributes.title
    }));
  },
  submit: searchTerm => {
    dispatch((0, _state_management.submitSearch)(searchTerm));
  }
}))(SearchBarComponent);