"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconOffset = exports.IconRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _react = _interopRequireDefault(require("react"));
var _assets = require("./maki_icons/assets");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/icon_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getIconColor(color) {
  if (color == null) {
    return 'black';
  }
  return (0, _eui.isColorDark)(...(0, _chromaJs.default)(color).rgb()) ? 'white' : 'black';
}
const getIconOffset = icon => {
  if (icon == null) {
    return;
  }
  return {
    x: 7.5,
    y: 8.5
  };
};
exports.getIconOffset = getIconOffset;
const IconRenderer = ({
  icon,
  color,
  className,
  onClick,
  x,
  y,
  ...otherIconProps
}) => {
  if (icon == null) {
    return null;
  }
  const backgroundColor = getIconColor(color);
  if (icon.package === 'maki') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      type: _assets.MAKI_ICONS[icon.id].Svg,
      "aria-label": _assets.MAKI_ICONS[icon.id].label,
      color: backgroundColor,
      className: className,
      onClick: onClick,
      x: x,
      y: y
    }, otherIconProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
    type: icon.id,
    color: backgroundColor,
    className: className,
    onClick: onClick,
    x: x,
    y: y
  }, otherIconProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }));
};
exports.IconRenderer = IconRenderer;