"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiSettingsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _configSchema = require("@kbn/config-schema");
var _register_routes = require("./routes/register_routes");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GenAiSettingsPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    const routeHandlerPlugins = {
      actions: {
        setup: plugins.actions,
        start: () => core.getStartServices().then(([, starts]) => starts.actions)
      },
      inference: {
        setup: plugins.inference,
        start: () => core.getStartServices().then(([, starts]) => starts.inference)
      }
    };
    const withCore = {
      ...routeHandlerPlugins,
      core: {
        setup: core,
        start: () => core.getStartServices().then(([coreStart]) => coreStart)
      }
    };
    (0, _register_routes.registerServerRoutes)({
      core,
      logger: this.logger,
      dependencies: {
        plugins: withCore
      },
      isDev: false
    });
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]: {
        readonlyMode: 'ui',
        readonly: true,
        schema: _configSchema.schema.string(),
        value: _constants.NO_DEFAULT_CONNECTOR
      }
    });
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]: {
        readonlyMode: 'ui',
        readonly: true,
        schema: _configSchema.schema.boolean(),
        value: false
      }
    });
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.GenAiSettingsPlugin = GenAiSettingsPlugin;