"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleSetupTask = scheduleSetupTask;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function scheduleSetupTask(taskManagerStart) {
  await taskManagerStart.ensureScheduled({
    id: `${_utils.TASK_TYPE}:backportPackagePolicyInputId`,
    scope: ['fleet'],
    params: {
      type: 'backportPackagePolicyInputId'
    },
    taskType: _utils.TASK_TYPE,
    runAt: new Date(Date.now() + 3 * 1000),
    state: {}
  });
}