"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.airGappedUtils = void 0;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const airGappedUtils = () => {
  const config = _.appContextService.getConfig();
  const hasRegistryUrls = (config === null || config === void 0 ? void 0 : config.registryUrl) || (config === null || config === void 0 ? void 0 : config.registryProxyUrl);
  const isAirGapped = config === null || config === void 0 ? void 0 : config.isAirGapped;
  const shouldSkipRegistryRequests = isAirGapped && !hasRegistryUrls;
  return {
    hasRegistryUrls,
    isAirGapped,
    shouldSkipRegistryRequests
  };
};
exports.airGappedUtils = airGappedUtils;