"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV880 = exports.ALLOWED_SCHEDULES_IN_MINUTES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALLOWED_SCHEDULES_IN_MINUTES = exports.ALLOWED_SCHEDULES_IN_MINUTES = ['1', '3', '5', '10', '15', '20', '30', '60', '120', '240'];
const migratePackagePolicyToV880 = packagePolicyDoc => {
  var _packagePolicyDoc$att, _enabledStream$vars$s, _enabledStream$compil, _enabledStream$vars, _enabledStream$compil2;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'synthetics' || !packagePolicyDoc.attributes.is_managed) {
    return packagePolicyDoc;
  }
  const agentPolicyId = packagePolicyDoc.attributes.policy_id;
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const enabledInput = updatedPackagePolicyDoc.attributes.inputs.find(input => input.enabled === true);
  const enabledStream = enabledInput === null || enabledInput === void 0 ? void 0 : enabledInput.streams.find(stream => {
    return ['browser', 'http', 'icmp', 'tcp'].includes(stream.data_stream.dataset);
  });
  if (!enabledStream) {
    return updatedPackagePolicyDoc;
  }
  if (enabledStream.vars && (_enabledStream$vars$s = enabledStream.vars.schedule) !== null && _enabledStream$vars$s !== void 0 && _enabledStream$vars$s.value && (_enabledStream$compil = enabledStream.compiled_stream) !== null && _enabledStream$compil !== void 0 && _enabledStream$compil.schedule) {
    var _enabledStream$vars$s2;
    const schedule = (_enabledStream$vars$s2 = enabledStream.vars.schedule.value.match(/\d+\.?\d*/g)) === null || _enabledStream$vars$s2 === void 0 ? void 0 : _enabledStream$vars$s2[0];
    const updatedSchedule = getNearestSupportedSchedule(schedule);
    const formattedUpdatedSchedule = `@every ${updatedSchedule}m`;
    enabledStream.vars.schedule.value = `"${formattedUpdatedSchedule}"`;
    enabledStream.compiled_stream.schedule = formattedUpdatedSchedule;
  }
  if (enabledStream.data_stream.dataset === 'browser' && (_enabledStream$vars = enabledStream.vars) !== null && _enabledStream$vars !== void 0 && _enabledStream$vars['throttling.config'] && (_enabledStream$compil2 = enabledStream.compiled_stream) !== null && _enabledStream$compil2 !== void 0 && _enabledStream$compil2.throttling) {
    const throttling = enabledStream.vars['throttling.config'].value;
    if (throttling) {
      const formattedThrottling = handleThrottling(throttling);
      enabledStream.vars['throttling.config'].value = JSON.stringify(formattedThrottling);
      enabledStream.compiled_stream.throttling = formattedThrottling;
    }
  }

  // set location_id.id to agentPolicyId
  if (enabledStream.vars) {
    enabledStream.vars.location_id = {
      value: agentPolicyId,
      type: 'text'
    };
    enabledStream.compiled_stream.location_id = agentPolicyId;
  }
  return updatedPackagePolicyDoc;
};
exports.migratePackagePolicyToV880 = migratePackagePolicyToV880;
const handleThrottling = throttling => {
  try {
    const [download = 5, upload = 3, latency = 20] = throttling.match(/\d+\.?\d*/g) || [];
    return {
      download: Number(download),
      upload: Number(upload),
      latency: Number(latency)
    };
  } catch {
    return {
      download: 5,
      upload: 3,
      latency: 20
    };
  }
};
const getNearestSupportedSchedule = currentSchedule => {
  try {
    const closest = ALLOWED_SCHEDULES_IN_MINUTES.reduce(function (prev, curr) {
      const supportedSchedule = parseFloat(curr);
      const currSchedule = parseFloat(currentSchedule);
      const prevSupportedSchedule = parseFloat(prev);
      return Math.abs(supportedSchedule - currSchedule) < Math.abs(prevSupportedSchedule - currSchedule) ? curr : prev;
    });
    return closest;
  } catch {
    return '10';
  }
};