"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectCreateAgentPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _components = require("../../applications/fleet/sections/agents/components");
var _components2 = require("../../applications/fleet/sections/agent_policy/components");
var _services = require("../../services");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/agent_policy_select_create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectCreateAgentPolicy = ({
  agentPolicies,
  excludeFleetServer,
  setSelectedPolicyId,
  selectedPolicyId,
  withKeySelection,
  selectedApiKeyId,
  onKeyChange,
  isFleetServerPolicy,
  refreshAgentPolicies
}) => {
  const regularAgentPolicies = (0, _react.useMemo)(() => {
    return agentPolicies.filter(policy => policy && !policy.is_managed && (!excludeFleetServer || !policy.is_default_fleet_server));
  }, [agentPolicies, excludeFleetServer]);
  (0, _react.useEffect)(() => {
    // Select default value if policy has no fleet server
    if (regularAgentPolicies.length === 1 && !selectedPolicyId && excludeFleetServer !== false && !(0, _services.policyHasFleetServer)(regularAgentPolicies[0])) {
      setSelectedPolicyId(regularAgentPolicies[0].id);
    }
  }, [regularAgentPolicies, selectedPolicyId, setSelectedPolicyId, excludeFleetServer]);
  const onAgentPolicyChange = (0, _react.useCallback)(async (key, policy) => {
    if (policy) {
      refreshAgentPolicies();
    }
  }, [refreshAgentPolicies]);
  const [showCreatePolicy, setShowCreatePolicy] = (0, _react.useState)(regularAgentPolicies.length === 0);
  const [createState, setCreateState] = (0, _react.useState)({
    status: _components.CREATE_STATUS.INITIAL
  });
  const [newName, setNewName] = (0, _react.useState)((0, _services.incrementPolicyName)(regularAgentPolicies, isFleetServerPolicy));
  (0, _react.useEffect)(() => {
    setShowCreatePolicy(regularAgentPolicies.length === 0 && !selectedPolicyId);
    setNewName((0, _services.incrementPolicyName)(regularAgentPolicies, isFleetServerPolicy));
  }, [regularAgentPolicies, isFleetServerPolicy, selectedPolicyId]);
  const onAgentPolicyCreated = (0, _react.useCallback)(async (policy, errorMessage) => {
    if (!policy) {
      setCreateState({
        status: _components.CREATE_STATUS.FAILED,
        errorMessage
      });
      return;
    }
    setShowCreatePolicy(false);
    setCreateState({
      status: _components.CREATE_STATUS.CREATED
    });
    if (onAgentPolicyChange) {
      onAgentPolicyChange(policy.id, policy);
    }
    setSelectedPolicyId(policy.id);
  }, [setSelectedPolicyId, onAgentPolicyChange]);
  const onClickCreatePolicy = () => {
    setCreateState({
      status: _components.CREATE_STATUS.INITIAL
    });
    setShowCreatePolicy(true);
    if (withKeySelection && onKeyChange) {
      onKeyChange(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCreatePolicy ? /*#__PURE__*/_react.default.createElement(_components2.AgentPolicyCreateInlineForm, {
    updateAgentPolicy: onAgentPolicyCreated,
    isFleetServerPolicy: isFleetServerPolicy,
    agentPolicyName: newName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_.AgentPolicySelection, {
    agentPolicies: regularAgentPolicies,
    withKeySelection: withKeySelection,
    selectedApiKeyId: selectedApiKeyId,
    onKeyChange: onKeyChange,
    excludeFleetServer: excludeFleetServer,
    onClickCreatePolicy: onClickCreatePolicy,
    selectedPolicyId: selectedPolicyId,
    setSelectedPolicyId: setSelectedPolicyId,
    isFleetServerPolicy: isFleetServerPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }), createState.status !== _components.CREATE_STATUS.INITIAL && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyCreatedCallOut, {
    createState: createState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }));
};
exports.SelectCreateAgentPolicy = SelectCreateAgentPolicy;