"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResizablePanelComponent = exports.ResizablePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/resizable_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getMouseOrTouchY = e => {
  const x = e.targetTouches ? e.targetTouches[0].pageY : e.pageY;
  return -x;
};
const ResizablePanelComponent = ({
  children,
  isCollapsed,
  topBar
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const [panelHeight, setPanelHeight] = (0, _react.useState)(300);
  const initialPanelHeight = (0, _react.useRef)(panelHeight);
  const initialMouseY = (0, _react.useRef)(0);
  const normalizeHeight = (0, _react.useCallback)(height => {
    const marginTop = parseInt(euiTheme.euiTheme.size.xxxxl, 10);
    // Be sure to not go over top bar
    return Math.min(Math.max(height, 0), window.innerHeight - marginTop * 3);
  }, [euiTheme.euiTheme.size.xxxxl]);
  (0, _react.useEffect)(() => {
    function onResize() {
      const normalizedHeight = normalizeHeight(panelHeight);
      if (normalizedHeight !== panelHeight) {
        setPanelHeight(normalizedHeight);
      }
    }
    window.addEventListener('resize', onResize);
    return () => {
      window.removeEventListener('resize', onResize);
    };
  }, [panelHeight, normalizeHeight]);
  const onMouseMove = (0, _react.useCallback)(e => {
    const mouseOffset = getMouseOrTouchY(e) - initialMouseY.current;
    const changedPanelHeight = initialPanelHeight.current + mouseOffset;
    setPanelHeight(normalizeHeight(changedPanelHeight));
  }, [normalizeHeight]);
  const onMouseUp = (0, _react.useCallback)(() => {
    initialMouseY.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove]);
  const onMouseDown = (0, _react.useCallback)(e => {
    initialMouseY.current = getMouseOrTouchY(e);
    initialPanelHeight.current = panelHeight;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [panelHeight, onMouseMove, onMouseUp]);
  const onKeyDown = (0, _react.useCallback)(e => {
    const KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _eui.keys.ARROW_UP:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setPanelHeight(currentPanelHeight => normalizeHeight(currentPanelHeight + KEYBOARD_OFFSET));
        break;
      case _eui.keys.ARROW_DOWN:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setPanelHeight(currentPanelHeight => normalizeHeight(currentPanelHeight - KEYBOARD_OFFSET));
    }
  }, [normalizeHeight]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
        position: fixed;
        padding: 0;
        bottom: 0;
        background: ${euiTheme.euiTheme.colors.backgroundBasePlain};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, topBar, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableButton, {
    css: (0, _react2.css)`
          position: absolute;
          top: 0;
        `,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onKeyDown: onKeyDown,
    disabled: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    css: (0, _react2.css)`
          background: ${euiTheme.euiTheme.colors.backgroundBasePlain};
          height: ${isCollapsed ? 0 : panelHeight}px;
          overflow: auto;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, children));
};
exports.ResizablePanelComponent = ResizablePanelComponent;
const ResizablePanel = ({
  title,
  content,
  onClose
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const paddingStyles = (0, _eui.useEuiPaddingCSS)();
  const cssStyles = [paddingStyles.m];
  const toggleCollpase = (0, _react.useCallback)(() => {
    setIsCollapsed(current => !current);
  }, []);
  const [isCollapsed, setIsCollapsed] = (0, _react.useState)(false);
  const topBar = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        background: ${euiTheme.euiTheme.colors.backgroundBaseFormsPrepend};
        ${cssStyles}
      `,
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, isCollapsed ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    key: "arrowUp",
    iconType: "arrowUp",
    "aria-label": _i18n.i18n.translate('xpack.fleet.integrationsResizablePanel.collapseButton', {
      defaultMessage: 'Collapse panel'
    }),
    color: "text",
    onClick: toggleCollpase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    key: "arrowDown",
    iconType: "arrowDown",
    "aria-label": _i18n.i18n.translate('xpack.fleet.integrationsResizablePanel.collapseButton', {
      defaultMessage: 'Collapse panel'
    }),
    color: "text",
    onClick: toggleCollpase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('xpack.fleet.integrationsResizablePanel.closeButton', {
      defaultMessage: 'Close panel'
    }),
    color: "text",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  })))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ResizablePanelComponent, {
    isCollapsed: isCollapsed,
    topBar: topBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, content));
};
exports.ResizablePanel = ResizablePanel;