"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _services = require("../../../../../../common/services");
var _constants = require("../../../../../../common/constants");
var _code_block = require("./code_block");
var _saved_object_names_combo = require("./saved_object_names_combo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/saved_object_debugger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchSavedObjects = async (type, name) => {
  var _response$data;
  if (!type || !name) return [];
  const response = await (0, _hooks.sendRequest)({
    method: 'post',
    path: _services.debugRoutesService.getSavedObjectsPath(),
    body: {
      type,
      name
    },
    version: _constants.API_VERSIONS.internal.v1
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.saved_objects;
};
const SavedObjectDebugger = () => {
  const types = [{
    value: `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.agentPolicyLabel', {
      defaultMessage: 'Agent policy'
    })
  }, {
    value: `${_constants.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.packagePolicyLabel', {
      defaultMessage: 'Integration policy'
    })
  }, {
    value: `${_constants.OUTPUT_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.outputLabel', {
      defaultMessage: 'Output'
    })
  }, {
    value: `${_constants.PACKAGES_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.packageLabel', {
      defaultMessage: 'Packages'
    })
  }, {
    value: `${_constants.DOWNLOAD_SOURCE_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.downloadSourceLabel', {
      defaultMessage: 'Download Sources'
    })
  }, {
    value: `${_constants.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE}`,
    text: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.fleetServerHostLabel', {
      defaultMessage: 'Fleet Server Hosts'
    })
  }];
  const [type, setType] = (0, _react.useState)(types[0].value);
  const [name, setName] = (0, _react.useState)();
  const [namesStatus, setNamesStatus] = (0, _react.useState)();
  const onTypeChange = e => {
    setType(e.target.value);
    setName(undefined);
  };
  const {
    data: savedObjectResult,
    status
  } = (0, _reactQuery.useQuery)(['debug-saved-objects', type, name], () => fetchSavedObjects(type, name));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.savedObjectDebugger.description",
    defaultMessage: "Search for Fleet-related saved objects by selecting a type and name. Use the code block below to diagnose any potential issues.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 300px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    prepend: "Type",
    id: "soType",
    options: types,
    value: type,
    onChange: e => onTypeChange(e),
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.selectTypeLabel', {
      defaultMessage: 'Select saved object type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 400px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_saved_object_names_combo.SavedObjectNamesCombo, {
    name: name,
    setName: setName,
    type: type,
    setNamesStatus: setNamesStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  })))), savedObjectResult && (status === 'error' || namesStatus === 'error') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.savedObjectDebugger.fetchError",
    defaultMessage: "Error fetching Saved Objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }))), (savedObjectResult || status === 'loading') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify(savedObjectResult, null, 2),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })));
};
exports.SavedObjectDebugger = SavedObjectDebugger;