"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefinePackagePolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _namespace_combo_box = require("../../../../../../../components/namespace_combo_box");
var _components = require("../../../../../components");
var _hooks = require("../../../../../hooks");
var _services = require("../../services");
var _components2 = require("./components");
var _hooks2 = require("./components/hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/step_define_package_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// on smaller screens, fields should be displayed in one column
const FormGroupResponsiveFields = (0, _styledComponents.default)(_eui.EuiDescribedFormGroup)`
  @media (max-width: 767px) {
    [class*='euiFlexGroup-responsive'] {
      align-items: flex-start;
    }
  }
`;
const StepDefinePackagePolicy = exports.StepDefinePackagePolicy = /*#__PURE__*/(0, _react.memo)(({
  namespacePlaceholder,
  packageInfo,
  packagePolicy,
  updatePackagePolicy,
  validationResults,
  submitAttempted,
  noAdvancedToggle = false,
  isEditPage = false
}) => {
  var _validationResults$ad;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();

  // Form show/hide states
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(noAdvancedToggle);

  // Package-level vars
  const requiredVars = [];
  const advancedVars = [];
  if (packageInfo.vars) {
    packageInfo.vars.forEach(varDef => {
      if ((0, _services.isAdvancedVar)(varDef)) {
        advancedVars.push(varDef);
      } else {
        requiredVars.push(varDef);
      }
    });
  }

  // Outputs
  const {
    isLoading: isOutputsLoading,
    canUseOutputPerIntegration,
    allowedOutputs
  } = (0, _hooks2.useOutputs)(packagePolicy, packageInfo.name);
  const {
    data: epmDatastreamsRes
  } = (0, _hooks.useGetEpmDatastreams)();
  const datastreamsOptions = (0, _react.useMemo)(() => {
    var _epmDatastreamsRes$it, _epmDatastreamsRes$it2;
    return (_epmDatastreamsRes$it = epmDatastreamsRes === null || epmDatastreamsRes === void 0 ? void 0 : (_epmDatastreamsRes$it2 = epmDatastreamsRes.items) === null || _epmDatastreamsRes$it2 === void 0 ? void 0 : _epmDatastreamsRes$it2.map(item => ({
      label: item.name,
      value: item.name
    }))) !== null && _epmDatastreamsRes$it !== void 0 ? _epmDatastreamsRes$it : [];
  }, [epmDatastreamsRes]);
  const selectedDatastreamOptions = (0, _react.useMemo)(() => {
    var _packagePolicy$additi, _packagePolicy$additi2;
    return (_packagePolicy$additi = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$additi2 = packagePolicy.additional_datastreams_permissions) === null || _packagePolicy$additi2 === void 0 ? void 0 : _packagePolicy$additi2.map(item => ({
      label: item,
      value: item
    }))) !== null && _packagePolicy$additi !== void 0 ? _packagePolicy$additi : [];
  }, [packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.additional_datastreams_permissions]);

  // Reset output if switching to agentless and the current
  // selected output is not allowed
  (0, _react.useEffect)(() => {
    if (packagePolicy.supports_agentless && packagePolicy.output_id) {
      const currentOutput = allowedOutputs.find(o => o.id === packagePolicy.output_id);
      if (!currentOutput) {
        updatePackagePolicy({
          output_id: null
        });
      }
    }
  }, [packagePolicy.supports_agentless, packagePolicy.output_id, allowedOutputs, updatePackagePolicy]);
  const advancedOptionsTitleId = (0, _eui.useGeneratedHtmlId)();

  // Managed policy
  const isManaged = packagePolicy.is_managed;
  return validationResults ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.managedReadonly",
      defaultMessage: "This is a managed package policy. You cannot modify it here.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }),
    iconType: "lock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(FormGroupResponsiveFields, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionTitle",
      defaultMessage: "Integration settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionDescription",
      defaultMessage: "Choose a name and description to help identify how this integration will be used.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: !!validationResults.name,
    error: validationResults.name,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNameInputLabel",
      defaultMessage: "Integration name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!validationResults.name,
    fullWidth: true,
    readOnly: isManaged,
    value: packagePolicy.name,
    onChange: e => updatePackagePolicy({
      name: e.target.value
    }),
    "data-test-subj": "packagePolicyNameInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDescriptionInputLabel",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 19
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",
      defaultMessage: "Optional",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 21
      }
    })),
    isInvalid: !!validationResults.description,
    error: validationResults.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!validationResults.description,
    fullWidth: true,
    readOnly: isManaged,
    value: packagePolicy.description,
    onChange: e => updatePackagePolicy({
      description: e.target.value
    }),
    "data-test-subj": "packagePolicyDescriptionInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 17
    }
  }))), requiredVars.map(varDef => {
    var _validationResults$va, _validationResults$va2;
    const {
      name: varName,
      type: varType
    } = varDef;
    if (!packagePolicy.vars || !packagePolicy.vars[varName]) return null;
    const value = packagePolicy.vars[varName].value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicy({
          vars: {
            ...packagePolicy.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_validationResults$va = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$va2 = validationResults.vars) === null || _validationResults$va2 === void 0 ? void 0 : _validationResults$va2[varName]) !== null && _validationResults$va !== void 0 ? _validationResults$va : [],
      forceShowErrors: submitAttempted,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 19
      }
    }));
  }), !noAdvancedToggle && !isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left",
    "aria-expanded": isShowingAdvanced,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    id: advancedOptionsTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",
    defaultMessage: "Advanced options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 25
    }
  })))), !isShowingAdvanced && !!validationResults.namespace ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 25
    }
  }))) : null)), isShowingAdvanced ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    role: "group",
    "aria-labelledby": advancedOptionsTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_namespace_combo_box.NamespaceComboBox, {
    namespace: packagePolicy.namespace || '',
    placeholder: namespacePlaceholder,
    isEditPage: isEditPage,
    packageType: packageInfo.type,
    validationError: validationResults.namespace,
    docLinks: docLinks,
    onNamespaceChange: newNamespace => {
      updatePackagePolicy({
        namespace: newNamespace
      });
    },
    "data-test-subj": "packagePolicyNamespaceInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 21
    }
  })), canUseOutputPerIntegration && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyOutputInputLabel",
      defaultMessage: "Output",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 27
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyOutputHelpLabel",
      defaultMessage: "Change the default output inherited from the parent agent policy. This setting changes where the integration's data is sent.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 27
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "packagePolicyOutputInput",
    isLoading: isOutputsLoading,
    options: [{
      value: '',
      text: ''
    }, ...allowedOutputs.map(output => ({
      value: output.id,
      text: output.name
    }))],
    value: packagePolicy.output_id || '',
    onChange: e => {
      updatePackagePolicy({
        output_id: e.target.value.trim() || null
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionLabel",
      defaultMessage: "Data retention settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 25
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionText",
      defaultMessage: "By default all logs and metrics data are stored on the hot tier. {learnMore} about changing the data retention policy for this integration.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsILM,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 385,
            columnNumber: 31
          }
        }, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataRetentionLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.additional_datastreams_permissions) !== null,
    error: (_validationResults$ad = validationResults === null || validationResults === void 0 ? void 0 : validationResults.additional_datastreams_permissions) !== null && _validationResults$ad !== void 0 ? _validationResults$ad : [],
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.additionalPermissionsLabel",
      defaultMessage: "Add a reroute processor permission {tooltip}",
      values: {
        tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.createPackagePolicy.stepConfigure.additionalPermissionsToolTip",
            defaultMessage: "Use the reroute processor to redirect data flows to another target index or data stream.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 411,
              columnNumber: 35
            }
          }),
          position: "right",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 409,
            columnNumber: 31
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.additional_datastreams_permissions) !== null,
    selectedOptions: selectedDatastreamOptions,
    options: datastreamsOptions,
    onChange: val => {
      updatePackagePolicy({
        additional_datastreams_permissions: val.map(v => v.label)
      });
    },
    onCreateOption: option => {
      var _packagePolicy$additi3;
      const additionalPermissions = (_packagePolicy$additi3 = packagePolicy.additional_datastreams_permissions) !== null && _packagePolicy$additi3 !== void 0 ? _packagePolicy$additi3 : [];
      updatePackagePolicy({
        additional_datastreams_permissions: [...additionalPermissions, option]
      });
    },
    placeholder: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.additionalPermissionsPlaceholder', {
      defaultMessage: 'Add a permission'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 23
    }
  }))), advancedVars.map(varDef => {
    var _validationResults$va3, _validationResults$va4;
    const {
      name: varName,
      type: varType
    } = varDef;
    if (!packagePolicy.vars || !packagePolicy.vars[varName]) return null;
    const value = packagePolicy.vars[varName].value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 455,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicy({
          vars: {
            ...packagePolicy.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_validationResults$va3 = validationResults === null || validationResults === void 0 ? void 0 : (_validationResults$va4 = validationResults.vars) === null || _validationResults$va4 === void 0 ? void 0 : _validationResults$va4[varName]) !== null && _validationResults$va3 !== void 0 ? _validationResults$va3 : [],
      forceShowErrors: submitAttempted,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 456,
        columnNumber: 25
      }
    }));
  }))) : null))) : /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 7
    }
  });
});