"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyCreateInlineForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _use_space_settings_context = require("../../../../../hooks/use_space_settings_context");
var _hooks = require("../../../hooks");
var _generate_new_agent_policy = require("../../../../../../common/services/generate_new_agent_policy");
var _ = require(".");
var _agent_policy_advanced_fields = require("./agent_policy_advanced_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_create_inline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const AgentPolicyCreateInlineForm = ({
  updateAgentPolicy,
  isFleetServerPolicy,
  agentPolicyName
}) => {
  const {
    docLinks,
    notifications
  } = (0, _hooks.useStartServices)();
  const authz = (0, _hooks.useAuthz)();
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isDisabled = !authz.fleet.allAgentPolicies || isLoading;
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
    name: agentPolicyName,
    has_fleet_server: isFleetServerPolicy,
    namespace: spaceSettings.defaultNamespace
  }));
  const updateNewAgentPolicy = (0, _react.useCallback)(updatedFields => {
    setNewAgentPolicy({
      ...newAgentPolicy,
      ...updatedFields
    });
  }, [setNewAgentPolicy, newAgentPolicy]);
  const validation = (0, _.agentPolicyFormValidation)(newAgentPolicy, {
    allowedNamespacePrefixes: spaceSettings.allowedNamespacePrefixes
  });
  const createAgentPolicy = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      const data = await (0, _hooks.sendCreateAgentPolicyForRq)(newAgentPolicy, {
        withSysMonitoring
      });
      updateAgentPolicy(data.item);
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.agentPolicyCreateInline.errorTitle', {
          defaultMessage: 'Error creating agent policy'
        })
      });
      updateAgentPolicy(null, mapError(e));
    } finally {
      setIsLoading(false);
    }
  }, [newAgentPolicy, withSysMonitoring, updateAgentPolicy, notifications.toasts]);
  function mapError(e) {
    switch (e.statusCode) {
      case 409:
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyCreation.errorMessage",
          defaultMessage: "An agent policy already exists with this name.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 11
          }
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyFleetServer",
    defaultMessage: "Fleet Server runs on Elastic Agent, and agents are enrolled in agent policies which represent hosts. We'll need to create a dedicated agent policy for Fleet Server to run on dedicated hosts.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyTypeOfHosts",
    defaultMessage: "Settings for the monitored host are configured in the {agentPolicy}. Create a new agent policy to get started.",
    values: {
      agentPolicy: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.agentPolicy,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.createAgentPolicyDocLink",
        defaultMessage: "agent policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "name",
    error: touchedFields.name && validation.name ? validation.name : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: newAgentPolicy.name,
    disabled: isDisabled,
    onChange: e => updateNewAgentPolicy({
      name: e.target.value
    }),
    isInvalid: Boolean(touchedFields.name && validation.name),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      name: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameFieldPlaceholder', {
      defaultMessage: 'Choose a name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    disabled: !newAgentPolicy.name,
    onClick: () => createAgentPolicy(),
    isLoading: isLoading,
    isDisabled: isDisabled,
    "data-test-subj": isFleetServerPolicy ? 'createFleetServerPolicyBtn' : 'createPolicyBtn',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.createAgentPolicyText",
    defaultMessage: "Create policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    isDisabled: isDisabled,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: value => setWithSysMonitoring(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedOptionsJustChanged",
    "data-test-subj": "advancedOptionsButton",
    isDisabled: isDisabled,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 13
      }
    }),
    buttonClassName: !isDisabled ? 'ingest-active-button' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: newAgentPolicy,
    updateAgentPolicy: updateNewAgentPolicy,
    validation: validation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }))));
};
exports.AgentPolicyCreateInlineForm = AgentPolicyCreateInlineForm;