"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatESQLColumns = formatESQLColumns;
exports.getESQLQueryColumns = getESQLQueryColumns;
exports.getESQLQueryColumnsRaw = getESQLQueryColumnsRaw;
exports.getESQLResults = getESQLResults;
exports.hasStartEndParams = exports.getStartEndParams = exports.getNamedParams = void 0;
var _i18n = require("@kbn/i18n");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _fieldTypes = require("@kbn/field-types");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const hasStartEndParams = query => /\?_tstart|\?_tend/i.test(query);
exports.hasStartEndParams = hasStartEndParams;
const getStartEndParams = (query, time) => {
  const startNamedParams = /\?_tstart/i.test(query);
  const endNamedParams = /\?_tend/i.test(query);
  if (time && (startNamedParams || endNamedParams)) {
    var _dateMath$parse, _dateMath$parse2;
    const timeParams = {
      start: startNamedParams ? (_dateMath$parse = _datemath.default.parse(time.from)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.toISOString() : undefined,
      end: endNamedParams ? (_dateMath$parse2 = _datemath.default.parse(time.to, {
        roundUp: true
      })) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.toISOString() : undefined
    };
    const namedParams = [];
    if (timeParams !== null && timeParams !== void 0 && timeParams.start) {
      namedParams.push({
        _tstart: timeParams.start
      });
    }
    if (timeParams !== null && timeParams !== void 0 && timeParams.end) {
      namedParams.push({
        _tend: timeParams.end
      });
    }
    return namedParams;
  }
  return [];
};
exports.getStartEndParams = getStartEndParams;
const getNamedParams = (query, timeRange, variables) => {
  const namedParams = getStartEndParams(query, timeRange);
  if (variables !== null && variables !== void 0 && variables.length) {
    variables === null || variables === void 0 ? void 0 : variables.forEach(({
      key,
      value
    }) => {
      namedParams.push({
        [key]: value
      });
    });
  }
  return namedParams;
};
exports.getNamedParams = getNamedParams;
function formatESQLColumns(columns) {
  return columns.map(({
    name,
    type
  }) => {
    const kibanaType = (0, _fieldTypes.esFieldTypeToKibanaFieldType)(type);
    return {
      id: name,
      name,
      meta: {
        type: kibanaType,
        esType: type
      }
    };
  });
}

// Returns the columns exactly as being returned by the _query endpoint
// Based on the search api from the data plugin
async function getESQLQueryColumnsRaw({
  esqlQuery,
  search,
  signal,
  timeRange,
  variables
}) {
  try {
    var _columns;
    const namedParams = getNamedParams(esqlQuery, timeRange, variables);
    const response = await (0, _rxjs.lastValueFrom)(search({
      params: {
        query: `${esqlQuery} | limit 0`,
        ...(namedParams.length ? {
          params: namedParams
        } : {})
      }
    }, {
      abortSignal: signal,
      strategy: 'esql_async'
    }));
    return (_columns = response.rawResponse.columns) !== null && _columns !== void 0 ? _columns : [];
  } catch (error) {
    throw new Error(_i18n.i18n.translate('esqlUtils.columnsErrorMsg', {
      defaultMessage: 'Unable to load columns. {errorMessage}',
      values: {
        errorMessage: error.message
      }
    }));
  }
}

// Returns the columns with the kibana format
// Based on the search api from the data plugin
async function getESQLQueryColumns({
  esqlQuery,
  search,
  signal,
  timeRange,
  variables
}) {
  try {
    var _formatESQLColumns;
    const rawColumns = await getESQLQueryColumnsRaw({
      esqlQuery,
      search,
      signal,
      timeRange,
      variables
    });
    const columns = (_formatESQLColumns = formatESQLColumns(rawColumns)) !== null && _formatESQLColumns !== void 0 ? _formatESQLColumns : [];
    return columns;
  } catch (error) {
    throw new Error(_i18n.i18n.translate('esqlUtils.columnsErrorMsg', {
      defaultMessage: 'Unable to load columns. {errorMessage}',
      values: {
        errorMessage: error.message
      }
    }));
  }
}

// Returns the table as being returned by the _query endpoint
// Based on the search api from the data plugin
async function getESQLResults({
  esqlQuery,
  search,
  signal,
  filter,
  dropNullColumns,
  timeRange,
  variables
}) {
  const namedParams = getNamedParams(esqlQuery, timeRange, variables);
  const result = await (0, _rxjs.lastValueFrom)(search({
    params: {
      ...(filter ? {
        filter
      } : {}),
      query: esqlQuery,
      ...(dropNullColumns ? {
        dropNullColumns: true
      } : {}),
      ...(namedParams.length ? {
        params: namedParams
      } : {})
    }
  }, {
    abortSignal: signal,
    strategy: 'esql_async'
  }));
  return {
    response: result.rawResponse,
    params: result.requestParams
  };
}