"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeCommandWithGeneratedCommandData = mergeCommandWithGeneratedCommandData;
var _commands = require("../definitions/generated/commands/commands");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function mapCommandNameToElasticsearchName(commandName) {
  const nameMapping = {
    'inline stats': 'inline_stats'
  };
  return nameMapping[commandName] || commandName;
}
function mergeCommandWithGeneratedCommandData(command) {
  const elasticsearchCommandName = mapCommandNameToElasticsearchName(command.name);
  const generatedMetadata = _commands.commandsMetadata[elasticsearchCommandName];
  if (!generatedMetadata || Object.keys(generatedMetadata).length === 0) {
    return command;
  }
  return {
    ...command,
    metadata: {
      ...command.metadata,
      ...(generatedMetadata.license && {
        license: generatedMetadata.license
      }),
      ...(generatedMetadata.observability_tier && {
        observabilityTier: generatedMetadata.observability_tier
      })
    }
  };
}