"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormWizardNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/public/forms/form_wizard/form_wizard_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DEFAULT_TEXTS = {
  back: _i18n.i18n.translate('esUi.formWizard.backButtonLabel', {
    defaultMessage: 'Back'
  }),
  next: _i18n.i18n.translate('esUi.formWizard.nextButtonLabel', {
    defaultMessage: 'Next'
  }),
  save: _i18n.i18n.translate('esUi.formWizard.saveButtonLabel', {
    defaultMessage: 'Save'
  }),
  saving: _i18n.i18n.translate('esUi.formWizard.savingButtonLabel', {
    defaultMessage: 'Saving...'
  })
};
const FormWizardNav = ({
  activeStepIndex,
  lastStep,
  isStepValid,
  isSaving,
  onBack,
  onNext,
  texts,
  getRightContent
}) => {
  const isLastStep = activeStepIndex === lastStep;
  const labels = {
    ...DEFAULT_TEXTS,
    ...texts
  };
  const nextButtonLabel = isLastStep ? Boolean(isSaving) ? labels.saving : labels.save : labels.next;
  const rightContent = getRightContent !== undefined ? getRightContent() : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, activeStepIndex > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: onBack,
    "data-test-subj": "backButton",
    disabled: isStepValid === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 15
    }
  }, labels.back)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: isLastStep ? 'check' : 'arrowRight',
    onClick: onNext,
    iconSide: isLastStep ? 'left' : 'right',
    disabled: isStepValid === false,
    "data-test-subj": "nextButton",
    isLoading: isSaving,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, nextButtonLabel)))), rightContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 24
    }
  }, rightContent));
};
exports.FormWizardNav = FormWizardNav;