"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyResponseFailurePrompt = getPolicyResponseFailurePrompt;
var _local_prompt_object = require("../../../../prompt/local_prompt_object");
var _prompt = require("../../../../prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getPolicyResponseFailurePrompt({
  actionsClient,
  connector,
  connectorId,
  model,
  provider,
  savedObjectsClient
}) {
  const prompts = await (0, _prompt.getPromptsByGroupId)({
    actionsClient,
    connector,
    connectorId,
    model,
    provider,
    savedObjectsClient,
    promptGroupId: _local_prompt_object.promptGroupId.defendInsights.policyResponseFailure,
    promptIds: [_prompt.promptDictionary.defendInsightsPolicyResponseFailureDefault, _prompt.promptDictionary.defendInsightsPolicyResponseFailureRefine, _prompt.promptDictionary.defendInsightsPolicyResponseFailureContinue, _prompt.promptDictionary.defendInsightsPolicyResponseFailureGroup, _prompt.promptDictionary.defendInsightsPolicyResponseFailureEvents, _prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsId, _prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsEndpointId, _prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsValue, _prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediation, _prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediationMessage, _prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediationLink]
  });
  const getPromptById = id => {
    var _prompts$find;
    return ((_prompts$find = prompts.find(prompt => prompt.promptId === id)) === null || _prompts$find === void 0 ? void 0 : _prompts$find.prompt) || '';
  };
  return {
    default: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureDefault),
    refine: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureRefine),
    continue: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureContinue),
    group: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureGroup),
    events: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureEvents),
    eventsId: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsId),
    eventsEndpointId: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsEndpointId),
    eventsValue: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureEventsValue),
    remediation: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediation),
    remediationMessage: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediationMessage),
    remediationLink: getPromptById(_prompt.promptDictionary.defendInsightsPolicyResponseFailureRemediationLink)
  };
}