"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityTracesDocumentProfileProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../../../../common/constants");
var _profiles = require("../../../../profiles");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OBSERVABILITY_TRACES_SPAN_DOCUMENT_PROFILE_ID = 'observability-traces-document-profile';
const createObservabilityTracesDocumentProfileProvider = ({
  tracesContextService,
  apmErrorsContextService,
  logsContextService
}) => ({
  profileId: OBSERVABILITY_TRACES_SPAN_DOCUMENT_PROFILE_ID,
  restrictedToProductFeature: _constants.TRACES_PRODUCT_FEATURE_ID,
  profile: {
    getDocViewer: (0, _accessors.createGetDocViewer)({
      apm: {
        errors: apmErrorsContextService.getErrorsIndexPattern(),
        traces: tracesContextService.getAllTracesIndexPattern()
      },
      logs: logsContextService.getAllLogsIndexPattern()
    })
  },
  resolve: ({
    record,
    rootContext
  }) => {
    const isObservabilitySolutionView = rootContext.solutionType === _profiles.SolutionType.Observability;
    if (isObservabilitySolutionView && isTraceDocument(record, tracesContextService.isTracesIndexPattern)) {
      return {
        isMatch: true,
        context: {
          type: _profiles.DocumentType.Trace
        }
      };
    }
    return {
      isMatch: false
    };
  }
});
exports.createObservabilityTracesDocumentProfileProvider = createObservabilityTracesDocumentProfileProvider;
function isTraceDocument(record, isTracesIndexPattern) {
  const traceId = (0, _discoverUtils.getFieldValue)(record, _discoverUtils.TRACE_ID_FIELD);
  const index = getFieldValues(record, _discoverUtils.INDEX_FIELD);
  const dataStream = getFieldValues(record, _discoverUtils.DATASTREAM_TYPE_FIELD);
  return (index.some(isTracesIndexPattern) || dataStream.includes(_profiles.DataSourceCategory.Traces)) && !!traceId;
}
const getFieldValues = (record, field) => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value : [value];
};