"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamDefaultRetentionPeriod = getDataStreamDefaultRetentionPeriod;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamDefaultRetentionPeriod({
  esClient
}) {
  let defaultRetention;
  try {
    var _persistent$data_stre, _persistent$data_stre2, _persistent$data_stre3, _defaults$data_stream, _defaults$data_stream2, _defaults$data_stream3;
    const {
      persistent,
      defaults
    } = await esClient.cluster.getSettings({
      include_defaults: true
    });
    const persistentDSRetention = persistent === null || persistent === void 0 ? void 0 : (_persistent$data_stre = persistent.data_streams) === null || _persistent$data_stre === void 0 ? void 0 : (_persistent$data_stre2 = _persistent$data_stre.lifecycle) === null || _persistent$data_stre2 === void 0 ? void 0 : (_persistent$data_stre3 = _persistent$data_stre2.retention) === null || _persistent$data_stre3 === void 0 ? void 0 : _persistent$data_stre3.failures_default;
    const defaultsDSRetention = defaults === null || defaults === void 0 ? void 0 : (_defaults$data_stream = defaults.data_streams) === null || _defaults$data_stream === void 0 ? void 0 : (_defaults$data_stream2 = _defaults$data_stream.lifecycle) === null || _defaults$data_stream2 === void 0 ? void 0 : (_defaults$data_stream3 = _defaults$data_stream2.retention) === null || _defaults$data_stream3 === void 0 ? void 0 : _defaults$data_stream3.failures_default;
    defaultRetention = persistentDSRetention !== null && persistentDSRetention !== void 0 ? persistentDSRetention : defaultsDSRetention;
  } catch (e) {
    var _e$meta;
    if (((_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : _e$meta.statusCode) === 403) {
      // if user doesn't have permissions to read cluster settings, we just return undefined
    } else {
      throw e;
    }
  }
  return defaultRetention;
}