"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQualityIssuesFilters = void 0;
var _react = require("@xstate/react");
var _react2 = require("react");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ISSUE_TYPE_OPTIONS = [{
  value: 'degraded',
  label: _translations.degradedField
}, {
  value: 'failed',
  label: _translations.documentIndexFailed
}];
const useQualityIssuesFilters = () => {
  const {
    service
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const {
    showCurrentQualityIssues,
    selectedIssueTypes,
    qualityIssues,
    selectedFields
  } = (0, _react.useSelector)(service, state => state.context);
  const {
    data
  } = qualityIssues !== null && qualityIssues !== void 0 ? qualityIssues : {};
  const toggleCurrentQualityIssues = (0, _react2.useCallback)(() => {
    service.send('TOGGLE_CURRENT_QUALITY_ISSUES');
  }, [service]);

  // Issue type filter logic
  const issueTypeItems = (0, _react2.useMemo)(() => {
    return ISSUE_TYPE_OPTIONS.map(({
      value,
      label
    }) => ({
      label,
      checked: selectedIssueTypes.includes(value) ? 'on' : undefined
    }));
  }, [selectedIssueTypes]);
  const onIssueTypesChange = (0, _react2.useCallback)(newIssueTypeItems => {
    const selectedTypes = newIssueTypeItems.filter(item => item.checked === 'on').map(item => {
      const option = ISSUE_TYPE_OPTIONS.find(opt => opt.label === item.label);
      return (option === null || option === void 0 ? void 0 : option.value) || item.label.toLowerCase();
    });
    service.send({
      type: 'UPDATE_SELECTED_ISSUE_TYPES',
      selectedIssueTypes: selectedTypes
    });
  }, [service]);

  // Field filter logic
  const availableFields = (0, _react2.useMemo)(() => {
    if (!data) return [];
    return [...new Set(data.map(issue => issue.type === 'degraded' ? {
      label: issue.name,
      value: issue.name
    } : {
      label: _translations.overviewPanelDatasetQualityIndicatorFailedDocs,
      value: issue.name
    }))].sort();
  }, [data]);
  const fieldItems = (0, _react2.useMemo)(() => {
    return availableFields.map(field => ({
      label: field.label,
      checked: selectedFields !== null && selectedFields !== void 0 && selectedFields.includes(field.value) ? 'on' : undefined
    }));
  }, [availableFields, selectedFields]);
  const onFieldsChange = (0, _react2.useCallback)(newFieldItems => {
    const selectedFieldsValues = newFieldItems.filter(item => item.checked === 'on').map(item => {
      const option = availableFields.find(opt => opt.label === item.label);
      return (option === null || option === void 0 ? void 0 : option.value) || item.label.toLowerCase();
    });
    service.send({
      type: 'UPDATE_SELECTED_FIELDS',
      selectedFields: selectedFieldsValues
    });
  }, [availableFields, service]);
  return {
    showCurrentQualityIssues,
    toggleCurrentQualityIssues,
    issueTypeItems,
    onIssueTypesChange,
    fieldItems,
    onFieldsChange
  };
};
exports.useQualityIssuesFilters = useQualityIssuesFilters;