"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = QualitySummaryCards;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../../../common/translations");
var _use_overview_summary_panel = require("../../../../hooks/use_overview_summary_panel");
var _use_quality_issues_docs_chart = require("../../../../hooks/use_quality_issues_docs_chart");
var _use_dataset_quality_details_state = require("../../../../hooks/use_dataset_quality_details_state");
var _use_failure_store_modal = require("../../../../hooks/use_failure_store_modal");
var _quality_indicator = require("../../../quality_indicator");
var _card = require("./card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/quality_summary_cards/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const degradedDocTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.details.degradedDocTooltip",
  defaultMessage: "Documents with the {ignoredProperty} property, usually due to malformed fields or exceeding the limit of total fields when {ignoredAboveSetting}.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      transparentBackground: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 24
      }
    }, "_ignored"),
    ignoredAboveSetting: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      transparentBackground: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 28
      }
    }, "_ignore_above: false")
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
});
const failedDocTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.details.failedDocTooltip",
  defaultMessage: "Documents that were rejected during ingestion, usually due to mapping errors or pipeline failures.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function QualitySummaryCards({
  selectedCard,
  setSelectedCard
}) {
  const {
    totalDocsCount,
    isSummaryPanelLoading,
    totalDegradedDocsCount,
    totalFailedDocsCount,
    degradedPercentage,
    failedPercentage,
    degradedQuality,
    failedQuality
  } = (0, _use_overview_summary_panel.useOverviewSummaryPanel)();
  const {
    handleDocsTrendChartChange
  } = (0, _use_quality_issues_docs_chart.useQualityIssuesDocsChart)();
  const {
    loadingState: {
      dataStreamSettingsLoading,
      dataStreamDetailsLoading
    }
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const {
    openModal,
    canUserReadFailureStore,
    canUserManageFailureStore,
    hasFailureStore,
    renderModal: renderFailureStoreModal
  } = (0, _use_failure_store_modal.useFailureStoreModal)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    style: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_card.Card, {
    isDisabled: false,
    isSelected: selectedCard === 'degraded',
    title: _translations.overviewPanelDatasetQualityIndicatorDegradedDocs,
    titleTooltipContent: degradedDocTooltip,
    kpiValue: totalDegradedDocsCount,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
      percentage: degradedPercentage,
      docsCount: +totalDocsCount,
      fewDocsTooltipContent: degradedDocsCount => _i18n.i18n.translate('xpack.datasetQuality.fewDegradedDocsTooltip', {
        defaultMessage: '{degradedDocsCount} degraded docs in this data set.',
        values: {
          degradedDocsCount
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.DatasetQualityIndicator, {
      isLoading: isSummaryPanelLoading,
      quality: degradedQuality,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }))),
    onClick: () => {
      handleDocsTrendChartChange('degraded');
      setSelectedCard('degraded');
    },
    isLoading: dataStreamSettingsLoading || dataStreamDetailsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, dataStreamSettingsLoading || dataStreamDetailsLoading || hasFailureStore && canUserReadFailureStore ? /*#__PURE__*/_react.default.createElement(_card.Card, {
    isLoading: dataStreamSettingsLoading || dataStreamDetailsLoading,
    isDisabled: false,
    isSelected: selectedCard === 'failed',
    title: _translations.overviewPanelDatasetQualityIndicatorFailedDocs,
    titleTooltipContent: failedDocTooltip,
    kpiValue: totalFailedDocsCount,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
      percentage: failedPercentage,
      docsCount: +totalFailedDocsCount,
      fewDocsTooltipContent: failedDocsCount => _i18n.i18n.translate('xpack.datasetQuality.fewFailedDocsTooltip', {
        defaultMessage: '{failedDocsCount} failed docs in this data set.',
        values: {
          failedDocsCount
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.DatasetQualityIndicator, {
      isLoading: isSummaryPanelLoading,
      quality: failedQuality,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 19
      }
    }))),
    onClick: () => {
      handleDocsTrendChartChange('failed');
      setSelectedCard('failed');
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_card.Card, {
    isDisabled: true,
    title: _translations.overviewPanelDatasetQualityIndicatorFailedDocs,
    titleTooltipContent: failedDocTooltip,
    kpiValue: _i18n.i18n.translate('xpack.datasetQuality.noFailureStoreTitle', {
      defaultMessage: 'No failure store'
    }),
    footer: canUserManageFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: openModal,
      "data-test-subj": "datasetQualityDetailsEnableFailureStoreButton",
      "aria-label": _translations.enableFailureStoreButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 21
      }
    }, _translations.enableFailureStoreButtonLabel)),
    dataTestSubjTitle: "noFailureStore",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }), renderFailureStoreModal())));
}
module.exports = exports.default;