"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricDistributionChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _metric_distribution_chart_tooltip_header = require("./metric_distribution_chart_tooltip_header");
var _utils = require("../../../utils");
var _hooks = require("../../hooks");
var _column_chart_styles = require("../field_data_row/column_chart_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/metric_distribution_chart/metric_distribution_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SPEC_ID = 'metric_distribution';
const MetricDistributionChart = ({
  width,
  height,
  chartData,
  fieldFormat,
  hideXAxis
}) => {
  // This value is shown to label the y axis values in the tooltip.
  // Ideally we wouldn't show these values at all in the tooltip,
  // but this is not yet possible with Elastic charts.
  const seriesName = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.metricDistributionChart.seriesName', {
    defaultMessage: 'distribution'
  });
  const theme = (0, _hooks.useDataVizChartTheme)({
    disableGridLines: true
  });
  const styles = (0, _column_chart_styles.useColumnChartStyles)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const headerFormatter = tooltipData => {
    const xValue = tooltipData.value;
    const chartPoint = chartData.find(data => data.x === xValue);
    return /*#__PURE__*/_react.default.createElement(_metric_distribution_chart_tooltip_header.MetricDistributionChartTooltipHeader, {
      chartPoint: chartPoint,
      maxWidth: width,
      fieldFormat: fieldFormat,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dataVisualizerFieldDataMetricDistributionChart",
    css: styles.histogram,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width,
      height
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: headerFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    theme: theme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: d => (0, _utils.kibanaFieldFormat)(d, fieldFormat),
    hide: hideXAxis === true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => d.toFixed(3),
    hide: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: SPEC_ID,
    name: seriesName,
    xScaleType: _charts.ScaleType.Linear,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: chartData.length > 0 ? chartData : [{
      x: 0,
      y: 0,
      dataMin: 0,
      dataMax: 0,
      percent: 0
    }],
    curve: _charts.CurveType.CURVE_STEP_AFTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
};
exports.MetricDistributionChart = MetricDistributionChart;