"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveFieldTypeOrNameChangedModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/confirm_modals/save_field_type_or_name_changed_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const geti18nTexts = fieldName => ({
  cancelButtonText: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmationModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  confirmButtonText: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmationModal.saveButtonLabel', {
    defaultMessage: 'Save changes'
  }),
  warningChangingFields: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.warningChangingFields', {
    defaultMessage: 'Changing name or type can break searches and visualizations that rely on this field.'
  }),
  typeConfirm: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmModal.typeConfirm', {
    defaultMessage: 'Enter CHANGE to continue'
  }),
  titleConfirmChanges: _i18n.i18n.translate('indexPatternFieldEditor.saveRuntimeField.confirmModal.title', {
    defaultMessage: `Save changes to ''{name}''`,
    values: {
      name: fieldName
    }
  })
});
const SaveFieldTypeOrNameChangedModal = ({
  fieldName,
  onCancel,
  onConfirm
}) => {
  const i18nTexts = geti18nTexts(fieldName);
  const [confirmContent, setConfirmContent] = (0, _react.useState)('');
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: i18nTexts.titleConfirmChanges,
    titleProps: {
      id: confirmModalTitleId
    },
    "data-test-subj": "runtimeFieldSaveConfirmModal",
    cancelButtonText: i18nTexts.cancelButtonText,
    confirmButtonText: i18nTexts.confirmButtonText,
    confirmButtonDisabled: (confirmContent === null || confirmContent === void 0 ? void 0 : confirmContent.toUpperCase()) !== 'CHANGE',
    onCancel: onCancel,
    onConfirm: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: i18nTexts.warningChangingFields,
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18nTexts.typeConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: confirmContent,
    onChange: e => setConfirmContent(e.target.value),
    "data-test-subj": "saveModalConfirmText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  })));
};
exports.SaveFieldTypeOrNameChangedModal = SaveFieldTypeOrNameChangedModal;