"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _dataset_quality_link = require("./dataset_quality_link");
var _use_kibana = require("../../utils/use_kibana");
var _legend_action_item = require("./legend_action_item");
var _translations = require("../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/legend_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LegendAction = exports.LegendAction = /*#__PURE__*/_react.default.memo(({
  label,
  idx,
  popoverOpen,
  togglePopover
}) => {
  const uniqueStreamName = `${idx}-${label}`;
  const {
    services: {
      share: {
        url: {
          locators
        }
      },
      application: {
        capabilities
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const hasDataSetQualityFeature = !!(capabilities !== null && capabilities !== void 0 && capabilities.data_quality);
  const hasIndexManagementFeature = !!(capabilities !== null && capabilities !== void 0 && capabilities.index_management);
  const onClickIndexManagement = (0, _react.useCallback)(async () => {
    const locator = locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
    if (locator) {
      await locator.navigate({
        page: 'data_streams_details',
        dataStreamName: label
      });
    }
    togglePopover(null); // Close the popover after action
  }, [label, locators, togglePopover]);
  const onCopyDataStreamName = (0, _react.useCallback)(() => {
    navigator.clipboard.writeText(label);
    togglePopover(null); // Close popover after copying
  }, [label, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "legendActionPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesHorizontal",
      "aria-label": _translations.UX_LABELS.dataQualityPopup.open,
      onClick: () => togglePopover(uniqueStreamName),
      "data-test-subj": "legendActionButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }))),
    isOpen: popoverOpen === uniqueStreamName,
    closePopover: () => togglePopover(null),
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_legend_action_item.LegendActionItem, {
    label: _translations.UX_LABELS.dataQualityPopup.copy,
    onClick: onCopyDataStreamName,
    dataTestSubj: "copyDataStreamNameAction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }), hasIndexManagementFeature && /*#__PURE__*/_react.default.createElement(_legend_action_item.LegendActionItem, {
    label: _translations.UX_LABELS.dataQualityPopup.manage,
    onClick: onClickIndexManagement,
    dataTestSubj: "manageDataStreamAction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }), hasDataSetQualityFeature && /*#__PURE__*/_react.default.createElement(_dataset_quality_link.DatasetQualityLink, {
    dataStreamName: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 42
    }
  }))));
});