"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadSavedObjects = loadSavedObjects;
var _coreDiInternal = require("@kbn/core-di-internal");
var _coreDiServer = require("@kbn/core-di-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function loadSavedObjects({
  bind
}) {
  bind(_coreDiServer.SavedObjectsClient).toResolvedValue(savedObjectsClientFactory => savedObjectsClientFactory(), [_coreDiServer.SavedObjectsClientFactory]).inRequestScope().onActivation((0, _coreDiInternal.cacheInScope)(_coreDiServer.SavedObjectsClient));
  bind(_coreDiServer.SavedObjectsClientFactory).toResolvedValue((savedObjectsStart, request) => options => savedObjectsStart.getScopedClient(request, options), [(0, _coreDiServer.CoreStart)('savedObjects'), _coreDiServer.Request]).inRequestScope().onActivation((0, _coreDiInternal.cacheInScope)(_coreDiServer.SavedObjectsClientFactory));
  bind(_coreDiServer.SavedObjectsTypeRegistry).toResolvedValue(savedObjectsStart => savedObjectsStart.getTypeRegistry(), [(0, _coreDiServer.CoreStart)('savedObjects')]).inSingletonScope();
}