"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TO_INDEX = exports.FROM_INDEX = void 0;
exports.getInterval = getInterval;
exports.getMomentTimezone = getMomentTimezone;
exports.getStepSize = getStepSize;
exports.getTicks = getTicks;
exports.roundDownToNextStepSizeFactor = roundDownToNextStepSizeFactor;
exports.roundUpToNextStepSizeFactor = roundUpToNextStepSizeFactor;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _common = require("@kbn/data-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/timeslider_control/time_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const MAX_TICKS = 20; // eui range has hard limit of 20 ticks and throws when exceeded

const FROM_INDEX = exports.FROM_INDEX = 0;
const TO_INDEX = exports.TO_INDEX = 1;
function getMomentTimezone(dateFormatTZ) {
  const detectedTimezone = _momentTimezone.default.tz.guess();
  return dateFormatTZ === undefined || dateFormatTZ === 'Browser' ? detectedTimezone : dateFormatTZ;
}
function getScaledDateFormat(interval) {
  if (interval >= _momentTimezone.default.duration(1, 'y').asMilliseconds()) {
    return 'YYYY';
  }
  if (interval >= _momentTimezone.default.duration(30, 'd').asMilliseconds()) {
    return 'MMM YYYY';
  }
  if (interval >= _momentTimezone.default.duration(1, 'd').asMilliseconds()) {
    return 'MMM D';
  }
  if (interval >= _momentTimezone.default.duration(6, 'h').asMilliseconds()) {
    return 'Do HH';
  }
  if (interval >= _momentTimezone.default.duration(1, 'h').asMilliseconds()) {
    return 'HH:mm';
  }
  if (interval >= _momentTimezone.default.duration(1, 'm').asMilliseconds()) {
    return 'HH:mm';
  }
  if (interval >= _momentTimezone.default.duration(1, 's').asMilliseconds()) {
    return 'mm:ss';
  }
  return 'ss.SSS';
}
function getInterval(min, max, steps = MAX_TICKS) {
  const duration = max - min;
  let interval = (0, _common.calcAutoIntervalNear)(MAX_TICKS, duration).asMilliseconds();
  // Sometimes auto interval is not quite right and returns 2X, 3X, 1/2X, or 1/3X  requested ticks
  const actualSteps = duration / interval;
  if (actualSteps > MAX_TICKS) {
    // EuiRange throws if ticks exceeds MAX_TICKS
    // Adjust the interval to ensure MAX_TICKS is never exceeded
    const factor = Math.ceil(actualSteps / MAX_TICKS);
    interval = interval * factor;
  } else if (actualSteps < MAX_TICKS / 2) {
    // Increase number of ticks when ticks is less then half MAX_TICKS
    interval = interval / 2;
  }
  return interval;
}
function getTicks(min, max, timezone) {
  const interval = getInterval(min, max);
  const format = getScaledDateFormat(interval);
  let tickValue = Math.ceil(min / interval) * interval;
  const ticks = [];
  while (tickValue <= max) {
    ticks.push({
      value: tickValue,
      label: _momentTimezone.default.tz(tickValue, getMomentTimezone(timezone)).format(format)
    });
    tickValue += interval;
  }
  return ticks.length <= 12 ? ticks : ticks.map((tick, index) => {
    return {
      ...tick,
      value: tick.value,
      // to avoid label overlap, only display even tick labels
      // Passing empty string as tick label results in tick not rendering, so must wrap empty label in react element
      label: index % 2 === 0 ? tick.label : /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 49
        }
      }, "\xA0")
    };
  });
}
function getStepSize(ticks) {
  if (ticks.length < 2) {
    return {
      stepSize: 1,
      format: 'MMM D, YYYY @ HH:mm:ss.SSS'
    };
  }
  const tickRange = ticks[1].value - ticks[0].value;
  if (tickRange >= _momentTimezone.default.duration(2, 'y').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'y').asMilliseconds(),
      format: 'YYYY'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'd').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'd').asMilliseconds(),
      format: 'MMM D, YYYY'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'h').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'h').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 'm').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 'm').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm'
    };
  }
  if (tickRange >= _momentTimezone.default.duration(2, 's').asMilliseconds()) {
    return {
      stepSize: _momentTimezone.default.duration(1, 's').asMilliseconds(),
      format: 'MMM D, YYYY @ HH:mm:ss'
    };
  }
  return {
    stepSize: 1,
    format: 'MMM D, YYYY @ HH:mm:ss.SSS'
  };
}
function roundDownToNextStepSizeFactor(value, stepSize) {
  const remainder = value % stepSize;
  return remainder === 0 ? value : value - remainder;
}
function roundUpToNextStepSizeFactor(value, stepSize) {
  const remainder = value % stepSize;
  return remainder === 0 ? value : value + (stepSize - remainder);
}