"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _constants = require("../../common/constants");
var _common = require("../../common");
var _compliance_dashboard = require("./compliance_dashboard/compliance_dashboard");
var _vulnerabilities_dashboard = require("./vulnerabilities_dashboard/vulnerabilities_dashboard");
var _benchmarks = require("./benchmarks/benchmarks");
var _status = require("./status/status");
var _find = require("./benchmark_rules/find/find");
var _get_detection_engine_alerts_count_by_rule_tags = require("./detection_engine/get_detection_engine_alerts_count_by_rule_tags");
var _bulk_action = require("./benchmark_rules/bulk_action/bulk_action");
var _get_states = require("./benchmark_rules/get_states/get_states");
var _data_views = require("../saved_objects/data_views");
var _route = require("./graph/route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * 1. Registers routes
 * 2. Registers routes handler context
 */
function setupRoutes({
  core,
  logger,
  isPluginInitialized
}) {
  const router = core.http.createRouter();
  (0, _compliance_dashboard.defineGetComplianceDashboardRoute)(router);
  (0, _vulnerabilities_dashboard.defineGetVulnerabilitiesDashboardRoute)(router);
  (0, _benchmarks.defineGetBenchmarksRoute)(router);
  (0, _status.defineGetCspStatusRoute)(router);
  (0, _find.defineFindCspBenchmarkRuleRoute)(router);
  (0, _get_detection_engine_alerts_count_by_rule_tags.defineGetDetectionEngineAlertsStatus)(router);
  (0, _bulk_action.defineBulkActionCspBenchmarkRulesRoute)(router);
  (0, _get_states.defineGetCspBenchmarkRulesStatesRoute)(router);
  (0, _route.defineGraphRoute)(router);
  core.http.registerOnPreRouting(async (request, response, toolkit) => {
    if (request.url.pathname.includes(_constants.CLOUD_SECURITY_INTERTAL_PREFIX_ROUTE_PATH)) {
      try {
        var _startDeps$spaces;
        const [coreStart, startDeps] = await core.getStartServices();
        const esClient = coreStart.elasticsearch.client.asInternalUser;
        const soClient = coreStart.savedObjects.createInternalRepository();
        const spaces = (_startDeps$spaces = startDeps.spaces) === null || _startDeps$spaces === void 0 ? void 0 : _startDeps$spaces.spacesService;
        const dataViews = startDeps.dataViews;
        await (0, _data_views.setupCdrDataViews)(esClient, soClient, spaces, dataViews, request, logger);
      } catch (err) {
        logger.error(`Failed to create CDR data views: ${err}`);
      }
    }
    return toolkit.next();
  });
  core.http.registerRouteHandlerContext(_common.PLUGIN_ID, async (context, request) => {
    const [, {
      security,
      fleet,
      spaces
    }] = await core.getStartServices();
    const coreContext = await context.core;
    await fleet.fleetSetupCompleted();
    let user = null;
    return {
      get user() {
        // We want to call getCurrentUser only when needed and only once
        if (!user) {
          user = security.authc.getCurrentUser(request);
        }
        return user;
      },
      logger,
      esClient: coreContext.elasticsearch.client,
      soClient: coreContext.savedObjects.client,
      spacesService: spaces === null || spaces === void 0 ? void 0 : spaces.spacesService,
      encryptedSavedObjects: coreContext.savedObjects.getClient({
        includedHiddenTypes: [_constants.INTERNAL_CSP_SETTINGS_SAVED_OBJECT_TYPE]
      }),
      agentPolicyService: fleet.agentPolicyService,
      agentService: fleet.agentService,
      packagePolicyService: fleet.packagePolicyService,
      packageService: fleet.packageService,
      isPluginInitialized
    };
  });
}