"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPostureInput = exports.hasPolicyTemplateInputs = exports.hasErrors = exports.getVulnMgmtCloudFormationDefaultValue = exports.getPostureType = exports.getPosturePolicy = exports.getPostureInputHiddenVars = exports.getPolicyTemplateInputOptions = exports.getMaxPackageName = exports.getDeploymentType = exports.POLICY_TEMPLATE_FORM_DTS = void 0;
var _lodash = require("lodash");
var _constants = require("@kbn/cloud-security-posture-common/constants");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _constants2 = require("../../../common/constants");
var _cis_eks_logo = _interopRequireDefault(require("../../assets/icons/cis_eks_logo.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudPostureIntegrations = {
  cspm: {
    policyTemplate: _constants.CSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.nameTitle', {
      defaultMessage: 'Cloud Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'CSPM'
    })
  },
  kspm: {
    policyTemplate: _constants.KSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.nameTitle', {
      defaultMessage: 'Kubernetes Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'KSPM'
    }),
    options: [{
      type: _constants2.CLOUDBEAT_VANILLA,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.nameTitle', {
        defaultMessage: 'Self-Managed'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.benchmarkTitle', {
        defaultMessage: 'CIS Kubernetes'
      }),
      icon: 'logoKubernetes',
      testId: 'cisK8sTestId'
    }, {
      type: _constants2.CLOUDBEAT_EKS,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.nameTitle', {
        defaultMessage: 'EKS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.benchmarkTitle', {
        defaultMessage: 'CIS EKS'
      }),
      icon: _cis_eks_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.tooltipContent', {
        defaultMessage: 'Elastic Kubernetes Service'
      }),
      testId: 'cisEksTestId'
    }]
  },
  vuln_mgmt: {
    policyTemplate: _constants2.VULN_MGMT_POLICY_TEMPLATE,
    name: 'Vulnerability Management',
    // TODO: we should use i18n and fix this
    shortName: 'VULN_MGMT',
    // TODO: we should use i18n and fix this
    options: [{
      type: _constants2.CLOUDBEAT_VULN_MGMT_AWS,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.awsOption.nameTitle', {
        defaultMessage: 'Amazon Web Services'
      }),
      icon: 'logoAWS',
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }]
  }
};
const DEFAULT_EKS_VARS_GROUP = 'assume_role';

// Extend NewPackagePolicyInput with known string literals for input type and policy template

const isPostureInput = input => _constants2.SUPPORTED_POLICY_TEMPLATES.includes(input.policy_template) && _constants2.SUPPORTED_CLOUDBEAT_INPUTS.includes(input.type);
exports.isPostureInput = isPostureInput;
const getPostureType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants2.CLOUDBEAT_AWS:
    case _constants2.CLOUDBEAT_AZURE:
    case _constants2.CLOUDBEAT_GCP:
      return 'cspm';
    case _constants2.CLOUDBEAT_VANILLA:
    case _constants2.CLOUDBEAT_EKS:
      return 'kspm';
    case _constants2.CLOUDBEAT_VULN_MGMT_AWS:
      return 'vuln_mgmt';
    default:
      return 'n/a';
  }
};
exports.getPostureType = getPostureType;
const getDeploymentType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants2.CLOUDBEAT_AWS:
    case _constants2.CLOUDBEAT_VULN_MGMT_AWS:
      return 'aws';
    case _constants2.CLOUDBEAT_AZURE:
      return 'azure';
    case _constants2.CLOUDBEAT_GCP:
      return 'gcp';
    case _constants2.CLOUDBEAT_VANILLA:
      return 'self_managed';
    case _constants2.CLOUDBEAT_EKS:
      return 'eks';
    default:
      return 'n/a';
  }
};
exports.getDeploymentType = getDeploymentType;
const getPostureInput = (input, inputType, inputVars) => {
  const isInputEnabled = input.type === inputType;
  return {
    ...input,
    enabled: isInputEnabled,
    streams: input.streams.map(stream => ({
      ...stream,
      enabled: isInputEnabled,
      // Merge new vars with existing vars
      ...(isInputEnabled && inputVars && {
        vars: {
          ...stream.vars,
          ...inputVars
        }
      })
    }))
  };
};

/**
 * Get a new object with the updated policy input and vars
 */
const getPosturePolicy = (newPolicy, inputType, inputVars) => ({
  ...newPolicy,
  namespace: newPolicy.namespace,
  // Enable new policy input and disable all others
  inputs: newPolicy.inputs.map(item => getPostureInput(item, inputType, inputVars)),
  // Set hidden policy vars
  vars: (0, _lodash.merge)({}, newPolicy.vars, {
    deployment: {
      value: getDeploymentType(inputType)
    },
    posture: {
      value: getPostureType(inputType)
    }
  })
});
exports.getPosturePolicy = getPosturePolicy;
// type guard for checking inputs
const hasPolicyTemplateInputs = policyTemplate => {
  return Object.hasOwn(policyTemplate, 'inputs');
};
exports.hasPolicyTemplateInputs = hasPolicyTemplateInputs;
const getVulnMgmtCloudFormationDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const vulnMgmtPolicyTemplate = packageInfo.policy_templates.find(p => p.name === _constants2.VULN_MGMT_POLICY_TEMPLATE);
  if (!vulnMgmtPolicyTemplate) return '';
  const vulnMgmtInputs = hasPolicyTemplateInputs(vulnMgmtPolicyTemplate) && vulnMgmtPolicyTemplate.inputs;
  if (!vulnMgmtInputs) return '';
  const cloudFormationTemplate = vulnMgmtInputs.reduce((acc, input) => {
    var _input$vars$find;
    if (!input.vars) return acc;
    const template = (_input$vars$find = input.vars.find(v => v.name === 'cloud_formation_template')) === null || _input$vars$find === void 0 ? void 0 : _input$vars$find.default;
    return template ? String(template) : acc;
  }, '');
  return cloudFormationTemplate;
};

/**
 * Input vars that are hidden from the user
 */
exports.getVulnMgmtCloudFormationDefaultValue = getVulnMgmtCloudFormationDefaultValue;
const getPostureInputHiddenVars = inputType => {
  switch (inputType) {
    case 'cloudbeat/cis_eks':
      return {
        'aws.credentials.type': {
          value: DEFAULT_EKS_VARS_GROUP,
          type: 'text'
        }
      };
    default:
      return undefined;
  }
};
exports.getPostureInputHiddenVars = getPostureInputHiddenVars;
const hasErrors = validationResults => {
  if (!validationResults) return 0;
  const flattenedValidation = (0, _std.getFlattenedObject)(validationResults);
  const errors = Object.values(flattenedValidation).filter(value => Boolean(value)) || [];
  return errors.length;
};
exports.hasErrors = hasErrors;
const getPolicyTemplateInputOptions = policyTemplate => {
  var _cloudPostureIntegrat;
  return (_cloudPostureIntegrat = cloudPostureIntegrations[policyTemplate].options) === null || _cloudPostureIntegrat === void 0 ? void 0 : _cloudPostureIntegrat.map(o => ({
    tooltip: o.tooltip,
    value: o.type,
    id: o.type,
    label: o.name,
    icon: o.icon,
    disabled: o.disabled,
    isBeta: o.isBeta,
    testId: o.testId
  }));
};
exports.getPolicyTemplateInputOptions = getPolicyTemplateInputOptions;
const getMaxPackageName = (packageName, packagePolicies) => {
  // Retrieve the highest number appended to package policy name and increment it by one
  const pkgPoliciesNamePattern = new RegExp(`${packageName}-(\\d+)`);
  const maxPkgPolicyName = Math.max(...(packagePolicies !== null && packagePolicies !== void 0 ? packagePolicies : []).filter(ds => Boolean(ds.name.match(pkgPoliciesNamePattern))).map(ds => parseInt(ds.name.match(pkgPoliciesNamePattern)[1], 10)), 0);
  return `${packageName}-${maxPkgPolicyName + 1}`;
};
exports.getMaxPackageName = getMaxPackageName;
const POLICY_TEMPLATE_FORM_DTS = exports.POLICY_TEMPLATE_FORM_DTS = {
  LOADER: 'policy-template-form-loader'
};