"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInternalESClient = createInternalESClient;
exports.createInternalESClientWithResources = createInternalESClientWithResources;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _register_apm_server_routes = require("../../../../routes/apm_routes/register_apm_server_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createInternalESClientWithResources({
  params,
  request,
  context
}) {
  const coreContext = await context.core;
  const {
    asInternalUser
  } = coreContext.elasticsearch.client;
  const debug = params.query._inspect;
  return createInternalESClient({
    debug,
    request,
    elasticsearchClient: asInternalUser
  });
}
async function createInternalESClient({
  debug,
  request,
  elasticsearchClient
}) {
  function callEs(operationName, {
    makeRequestWithSignal,
    params
  }) {
    return (0, _utils.callAsyncWithDebug)({
      cb: () => {
        const controller = new AbortController();
        const res = makeRequestWithSignal(controller.signal);
        return (0, _server.unwrapEsResponse)(request ? (0, _utils.cancelEsRequestOnAbort)(res, request, controller) : res);
      },
      debug,
      isCalledWithInternalUser: true,
      request,
      requestParams: params,
      operationName,
      inspectableEsQueriesMap: _register_apm_server_routes.inspectableEsQueriesMap
    });
  }
  return {
    search: async (operationName, params) => {
      return callEs(operationName, {
        makeRequestWithSignal: signal => elasticsearchClient.search(params, {
          signal,
          meta: true,
          context: {
            loggingOptions: getElasticsearchRequestLoggingOptions()
          }
        }),
        params
      });
    },
    index: (operationName, params) => {
      return callEs(operationName, {
        makeRequestWithSignal: signal => elasticsearchClient.index(params, {
          signal,
          meta: true,
          context: {
            loggingOptions: getElasticsearchRequestLoggingOptions()
          }
        }),
        params
      });
    },
    delete: (operationName, params) => {
      return callEs(operationName, {
        makeRequestWithSignal: signal => elasticsearchClient.delete(params, {
          signal,
          meta: true,
          context: {
            loggingOptions: getElasticsearchRequestLoggingOptions()
          }
        }),
        params
      });
    },
    indicesCreate: (operationName, params) => {
      return callEs(operationName, {
        makeRequestWithSignal: signal => elasticsearchClient.indices.create(params, {
          signal,
          meta: true,
          context: {
            loggingOptions: getElasticsearchRequestLoggingOptions()
          }
        }),
        params
      });
    }
  };
}
function getElasticsearchRequestLoggingOptions() {
  return {
    loggerName: 'apm'
  };
}