"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _style = require("../../../../utils/style");
var _polished = require("polished");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/kuery_bar/typeahead/suggestion.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getIconColor(type, theme) {
  switch (type) {
    case 'field':
      return theme.euiTheme.colors.vis.euiColorVis7;
    case 'value':
      return theme.euiTheme.colors.vis.euiColorVis0;
    case 'operator':
      return theme.euiTheme.colors.vis.euiColorVis1;
    case 'conjunction':
      return theme.euiTheme.colors.vis.euiColorVis3;
    case 'recentSearch':
      return theme.euiTheme.colors.mediumShade;
  }
}
const Description = _styled.default.div`
  color: ${({
  theme
}) => theme.euiTheme.colors.darkShade};

  p {
    display: inline;

    span {
      font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
      color: ${({
  theme
}) => theme.euiTheme.colors.fullShade};
      padding: 0 ${({
  theme
}) => theme.euiTheme.size.xs};
      display: inline-block;
    }
  }
`;
const ListItem = _styled.default.li`
  font-size: ${() => (0, _eui.useEuiFontSize)('xs').fontSize};
  height: ${({
  theme
}) => theme.euiTheme.size.xl};
  align-items: center;
  display: flex;
  background: ${({
  selected,
  theme
}) => selected ? theme.euiTheme.colors.lightestShade : 'initial'};
  cursor: pointer;
  border-radius: ${({
  theme
}) => theme.euiTheme.border.radius.small};

  ${Description} {
    p span {
      background: ${({
  selected,
  theme
}) => selected ? theme.euiTheme.colors.emptyShade : theme.euiTheme.colors.lightestShade};
    }
  }
`;
const Icon = _styled.default.div`
  flex: 0 0 ${({
  theme
}) => theme.euiTheme.size.xl};
  background: ${({
  type,
  theme
}) => (0, _polished.tint)(0.9, getIconColor(type, theme))};
  color: ${({
  type,
  theme
}) => getIconColor(type, theme)};
  width: 100%;
  height: 100%;
  text-align: center;
  line-height: ${({
  theme
}) => theme.euiTheme.size.xl};
`;
const TextValue = _styled.default.div`
  flex: 0 0 ${_style.unit * 16}px;
  color: ${({
  theme
}) => theme.euiTheme.colors.darkestShade};
  padding: 0 ${({
  theme
}) => theme.euiTheme.size.s};
`;
function getEuiIconType(type) {
  switch (type) {
    case 'field':
      return 'kqlField';
    case 'value':
      return 'kqlValue';
    case 'recentSearch':
      return 'search';
    case 'conjunction':
      return 'kqlSelector';
    case 'operator':
      return 'kqlOperand';
    default:
      throw new Error('Unknown type', type);
  }
}
function Suggestion(props) {
  return /*#__PURE__*/_react.default.createElement(ListItem, {
    innerRef: props.innerRef,
    selected: props.selected,
    onClick: () => props.onClick(props.suggestion),
    onMouseEnter: props.onMouseEnter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Icon, {
    type: props.suggestion.type,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getEuiIconType(props.suggestion.type),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(TextValue, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, props.suggestion.text), /*#__PURE__*/_react.default.createElement(Description, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, props.suggestion.description));
}
Suggestion.propTypes = {
  onClick: _propTypes.default.func.isRequired,
  onMouseEnter: _propTypes.default.func.isRequired,
  selected: _propTypes.default.bool,
  suggestion: _propTypes.default.object.isRequired,
  innerRef: _propTypes.default.func.isRequired
};
var _default = exports.default = Suggestion;
module.exports = exports.default;