"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_STATUS_ALL = void 0;
exports.AlertsOverview = AlertsOverview;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _apm_alerting_feature_ids = require("../../../../common/alerting/config/apm_alerting_feature_ids");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _url_helpers = require("../../shared/links/url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/alerts_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_STATUS_ALL = exports.ALERT_STATUS_ALL = 'all';
function AlertsOverview() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      rangeFrom,
      rangeTo,
      kuery
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/alerts', '/mobile-services/{serviceName}/alerts');
  const {
    services
  } = (0, _public2.useKibana)();
  const {
    core: {
      http,
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const [filterControls, setFilterControls] = (0, _react.useState)([]);
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const {
    triggersActionsUi: {
      getAlertsSearchBar: AlertsSearchBar
    },
    data,
    dataViews,
    spaces,
    uiSettings,
    fieldFormats,
    application,
    licensing,
    cases,
    settings
  } = services;
  const {
    query: {
      timefilter: {
        timefilter: timeFilterService
      }
    }
  } = data;
  const useToasts = () => notifications.toasts;
  const apmFilters = (0, _react.useMemo)(() => {
    const filters = [{
      query: {
        match_phrase: {
          [_apm.SERVICE_NAME]: serviceName
        }
      },
      meta: {}
    }];
    if ((0, _environment_filter_values.isEnvironmentDefined)(environment)) {
      filters.push({
        query: {
          match_phrase: {
            [_apm.SERVICE_ENVIRONMENT]: environment
          }
        },
        meta: {}
      });
    }
    return filters;
  }, [serviceName, environment]);
  const onKueryChange = (0, _react.useCallback)(value => (0, _url_helpers.push)(history, {
    query: {
      kuery: value
    }
  }), [history]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertSearchBar, {
    appName: 'apmApp',
    kuery: kuery,
    onRangeFromChange: value => (0, _url_helpers.push)(history, {
      query: {
        rangeFrom: value
      }
    }),
    onRangeToChange: value => (0, _url_helpers.push)(history, {
      query: {
        rangeTo: value
      }
    }),
    onKueryChange: onKueryChange,
    defaultFilters: apmFilters,
    filterControls: filterControls,
    onFilterControlsChange: setFilterControls,
    onEsQueryChange: setEsQuery,
    rangeTo: rangeTo,
    rangeFrom: rangeFrom,
    disableLocalStorageSync: true,
    services: {
      timeFilterService,
      AlertsSearchBar,
      http,
      data,
      dataViews,
      notifications,
      spaces,
      useToasts,
      uiSettings
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, esQuery && /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertsTable, {
    id: 'service-overview-alerts',
    ruleTypeIds: _apm_alerting_feature_ids.APM_ALERTING_RULE_TYPE_IDS,
    consumers: _apm_alerting_feature_ids.APM_ALERTING_CONSUMERS,
    query: esQuery,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }))));
}