"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.get = get;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _connector = require("../../../../data/connector");
var _schemas = require("../../schemas");
var _audit_events = require("../../../../lib/audit_events");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function get({
  context,
  id,
  throwIfSystemAction = true
}) {
  try {
    await context.authorization.ensureAuthorized({
      operation: 'get'
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.connectorAuditEvent)({
      action: _audit_events.ConnectorAuditAction.GET,
      savedObject: {
        type: 'action',
        id
      },
      error
    }));
    throw error;
  }
  const foundInMemoryConnector = context.inMemoryConnectors.find(connector => connector.id === id);

  /**
   * Getting system connector is not allowed
   * if throwIfSystemAction is set to true.
   * Default behavior is to throw
   */
  if (foundInMemoryConnector !== undefined && foundInMemoryConnector.isSystemAction && throwIfSystemAction) {
    throw _boom.default.notFound(`Connector ${id} not found`);
  }
  let connector;
  if (foundInMemoryConnector !== undefined) {
    var _context$auditLogger2;
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.connectorAuditEvent)({
      action: _audit_events.ConnectorAuditAction.GET,
      savedObject: {
        type: 'action',
        id
      }
    }));
    connector = {
      id,
      actionTypeId: foundInMemoryConnector.actionTypeId,
      name: foundInMemoryConnector.name,
      isPreconfigured: foundInMemoryConnector.isPreconfigured,
      isSystemAction: foundInMemoryConnector.isSystemAction,
      isDeprecated: (0, _lib.isConnectorDeprecated)(foundInMemoryConnector)
    };
    if (foundInMemoryConnector.exposeConfig) {
      connector.config = foundInMemoryConnector.config;
    }
  } else {
    var _context$auditLogger3;
    const result = await (0, _connector.getConnectorSo)({
      unsecuredSavedObjectsClient: context.unsecuredSavedObjectsClient,
      id
    });
    (_context$auditLogger3 = context.auditLogger) === null || _context$auditLogger3 === void 0 ? void 0 : _context$auditLogger3.log((0, _audit_events.connectorAuditEvent)({
      action: _audit_events.ConnectorAuditAction.GET,
      savedObject: {
        type: 'action',
        id
      }
    }));
    connector = {
      id,
      actionTypeId: result.attributes.actionTypeId,
      isMissingSecrets: result.attributes.isMissingSecrets,
      name: result.attributes.name,
      config: result.attributes.config,
      isPreconfigured: false,
      isSystemAction: false,
      isDeprecated: (0, _lib.isConnectorDeprecated)(result.attributes)
    };
  }

  // Try to validate the connector, but don't throw.
  try {
    _schemas.connectorSchema.validate(connector);
  } catch (e) {
    context.logger.warn(`Error validating connector: ${connector.id}, ${e}`);
  }
  return connector;
}