"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cacheNonRootPlanServiceNode = cacheNonRootPlanServiceNode;
const LazyPlanServiceNode_1 = require("../models/LazyPlanServiceNode");
function cacheNonRootPlanServiceNode(getPlanOptions, operations, planServiceNode, context) {
    if (getPlanOptions !== undefined &&
        ((LazyPlanServiceNode_1.LazyPlanServiceNode.is(planServiceNode) &&
            !planServiceNode.isExpanded()) ||
            planServiceNode.isContextFree)) {
        const planResult = {
            tree: {
                root: planServiceNode,
            },
        };
        operations.setPlan(getPlanOptions, planResult);
    }
    else {
        operations.setNonCachedServiceNode(planServiceNode, context);
    }
}
//# sourceMappingURL=cacheNonRootPlanServiceNode.js.map