"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setIsInjectableFlag = setIsInjectableFlag;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const classIsInjectableFlagReflectKey_1 = require("../../reflectMetadata/data/classIsInjectableFlagReflectKey");
// eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
function setIsInjectableFlag(target) {
    const isInjectableFlag = (0, reflect_metadata_utils_1.getOwnReflectMetadata)(target, classIsInjectableFlagReflectKey_1.classIsInjectableFlagReflectKey);
    if (isInjectableFlag !== undefined) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, `Cannot apply @injectable decorator multiple times at class "${target.name}"`);
    }
    (0, reflect_metadata_utils_1.setReflectMetadata)(target, classIsInjectableFlagReflectKey_1.classIsInjectableFlagReflectKey, true);
}
//# sourceMappingURL=setIsInjectableFlag.js.map