"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _initialize = require("./initialize");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DataStreamClient {
  constructor(client, dataStreams) {
    var _dataStreams$searchRu;
    (0, _defineProperty2.default)(this, "helpers", {
      getFieldsFromHit: hit => {
        var _hit$fields;
        const fields = (_hit$fields = hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {};
        return fields;
      }
    });
    (0, _defineProperty2.default)(this, "runtimeFields", void 0);
    this.client = client;
    this.dataStreams = dataStreams;
    this.runtimeFields = Object.keys((_dataStreams$searchRu = dataStreams.searchRuntimeMappings) !== null && _dataStreams$searchRu !== void 0 ? _dataStreams$searchRu : {});
  }
  async index(args) {
    return this.client.index({
      index: this.dataStreams.name,
      ...args
    });
  }
  async search(args, transportOpts) {
    return this.client.search({
      index: this.dataStreams.name,
      runtime_mappings: this.dataStreams.searchRuntimeMappings,
      fields: this.runtimeFields,
      ...args
    }, transportOpts);
  }

  /**
   * This function ensures setup has been run before returning an instance of the client.
   *
   * @remark This function should execute early in the application lifecycle and preferably once per
   *         data stream. However, it should be idempotent.
   */
  static async initialize(args) {
    await (0, _initialize.initialize)(args);
    return new DataStreamClient(args.elasticsearchClient, args.dataStreams);
  }

  // TODO: expose a create function that skips initialization
}
exports.DataStreamClient = DataStreamClient;