"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUsageCollector = void 0;
var _rxjs = require("rxjs");
var _analytics = require("@kbn/analytics");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createUsageCollector = (getStartServices, usageCollection) => {
  const getCurrentApp = async () => {
    const [{
      application
    }] = await getStartServices();
    return application.currentAppId$.pipe((0, _rxjs.first)()).toPromise();
  };
  const getCollector = (metricType, eventType) => {
    return async () => {
      const currentApp = await getCurrentApp();
      return usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(currentApp, metricType, eventType);
    };
  };
  return {
    trackQueryTimedOut: getCollector(_analytics.METRIC_TYPE.LOADED, _types.SEARCH_EVENT_TYPE.QUERY_TIMED_OUT),
    trackSessionIndicatorTourLoading: getCollector(_analytics.METRIC_TYPE.LOADED, _types.SEARCH_EVENT_TYPE.SESSION_INDICATOR_TOUR_LOADING),
    trackSessionIndicatorTourRestored: getCollector(_analytics.METRIC_TYPE.LOADED, _types.SEARCH_EVENT_TYPE.SESSION_INDICATOR_TOUR_RESTORED),
    trackSessionIndicatorSaveDisabled: getCollector(_analytics.METRIC_TYPE.LOADED, _types.SEARCH_EVENT_TYPE.SESSION_INDICATOR_SAVE_DISABLED),
    trackSessionSentToBackground: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_SENT_TO_BACKGROUND),
    trackSessionSavedResults: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_SAVED_RESULTS),
    trackSessionViewRestored: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_VIEW_RESTORED),
    trackSessionIsRestored: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_IS_RESTORED),
    trackSessionReloaded: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_RELOADED),
    trackSessionExtended: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_EXTENDED),
    trackSessionCancelled: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_CANCELLED),
    trackSessionDeleted: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_DELETED),
    trackViewSessionsList: getCollector(_analytics.METRIC_TYPE.CLICK, _types.SEARCH_EVENT_TYPE.SESSION_VIEW_LIST),
    trackSessionsListLoaded: getCollector(_analytics.METRIC_TYPE.LOADED, _types.SEARCH_EVENT_TYPE.SESSIONS_LIST_LOADED)
  };
};
exports.createUsageCollector = createUsageCollector;